/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaStreamTrack.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSMediaStreamTrack.h"
#include "JSMediaTrackCapabilities.h"
#include "JSMediaTrackConstraints.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaStreamTrack::State enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("live"),
        MAKE_STATIC_STRING_IMPL("ended"),
    };
    static_assert(static_cast<size_t>(MediaStreamTrack::State::Live) == 0, "MediaStreamTrack::State::Live is not 0 as expected");
    static_assert(static_cast<size_t>(MediaStreamTrack::State::Ended) == 1, "MediaStreamTrack::State::Ended is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediaStreamTrack::State enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediaStreamTrack::State> parseEnumerationFromString<MediaStreamTrack::State>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, MediaStreamTrack::State> mappings[] = {
        { "ended", MediaStreamTrack::State::Ended },
        { "live", MediaStreamTrack::State::Live },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediaStreamTrack::State> parseEnumeration<MediaStreamTrack::State>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediaStreamTrack::State>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<MediaStreamTrack::State>()
{
    return "\"live\", \"ended\"";
}

#if ENABLE(MEDIA_STREAM)

template<> MediaStreamTrack::TrackSettings convertDictionary<MediaStreamTrack::TrackSettings>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaStreamTrack::TrackSettings result;
    JSValue aspectRatioValue;
    if (isNullOrUndefined)
        aspectRatioValue = jsUndefined();
    else {
        aspectRatioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspectRatio"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aspectRatioValue.isUndefined()) {
        result.aspectRatio = convert<IDLDouble>(lexicalGlobalObject, aspectRatioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue deviceIdValue;
    if (isNullOrUndefined)
        deviceIdValue = jsUndefined();
    else {
        deviceIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "deviceId"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deviceIdValue.isUndefined()) {
        result.deviceId = convert<IDLDOMString>(lexicalGlobalObject, deviceIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue displaySurfaceValue;
    if (isNullOrUndefined)
        displaySurfaceValue = jsUndefined();
    else {
        displaySurfaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "displaySurface"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!displaySurfaceValue.isUndefined()) {
        result.displaySurface = convert<IDLDOMString>(lexicalGlobalObject, displaySurfaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue echoCancellationValue;
    if (isNullOrUndefined)
        echoCancellationValue = jsUndefined();
    else {
        echoCancellationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "echoCancellation"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!echoCancellationValue.isUndefined()) {
        result.echoCancellation = convert<IDLBoolean>(lexicalGlobalObject, echoCancellationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue facingModeValue;
    if (isNullOrUndefined)
        facingModeValue = jsUndefined();
    else {
        facingModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "facingMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!facingModeValue.isUndefined()) {
        result.facingMode = convert<IDLDOMString>(lexicalGlobalObject, facingModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue frameRateValue;
    if (isNullOrUndefined)
        frameRateValue = jsUndefined();
    else {
        frameRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameRate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!frameRateValue.isUndefined()) {
        result.frameRate = convert<IDLDouble>(lexicalGlobalObject, frameRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue groupIdValue;
    if (isNullOrUndefined)
        groupIdValue = jsUndefined();
    else {
        groupIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "groupId"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!groupIdValue.isUndefined()) {
        result.groupId = convert<IDLDOMString>(lexicalGlobalObject, groupIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heightValue.isUndefined()) {
        result.height = convert<IDLLong>(lexicalGlobalObject, heightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleRateValue;
    if (isNullOrUndefined)
        sampleRateValue = jsUndefined();
    else {
        sampleRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleRate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleRateValue.isUndefined()) {
        result.sampleRate = convert<IDLLong>(lexicalGlobalObject, sampleRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sampleSizeValue;
    if (isNullOrUndefined)
        sampleSizeValue = jsUndefined();
    else {
        sampleSizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleSize"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleSizeValue.isUndefined()) {
        result.sampleSize = convert<IDLLong>(lexicalGlobalObject, sampleSizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue volumeValue;
    if (isNullOrUndefined)
        volumeValue = jsUndefined();
    else {
        volumeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "volume"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!volumeValue.isUndefined()) {
        result.volume = convert<IDLDouble>(lexicalGlobalObject, volumeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!widthValue.isUndefined()) {
        result.width = convert<IDLLong>(lexicalGlobalObject, widthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue zoomValue;
    if (isNullOrUndefined)
        zoomValue = jsUndefined();
    else {
        zoomValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "zoom"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!zoomValue.isUndefined()) {
        result.zoom = convert<IDLDouble>(lexicalGlobalObject, zoomValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaStreamTrack::TrackSettings& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDouble::isNullValue(dictionary.aspectRatio)) {
        auto aspectRatioValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.aspectRatio));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "aspectRatio"_s), aspectRatioValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.deviceId)) {
        auto deviceIdValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.deviceId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "deviceId"_s), deviceIdValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.displaySurface)) {
        auto displaySurfaceValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.displaySurface));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "displaySurface"_s), displaySurfaceValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.echoCancellation)) {
        auto echoCancellationValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.echoCancellation));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "echoCancellation"_s), echoCancellationValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.facingMode)) {
        auto facingModeValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.facingMode));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "facingMode"_s), facingModeValue);
    }
    if (!IDLDouble::isNullValue(dictionary.frameRate)) {
        auto frameRateValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.frameRate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "frameRate"_s), frameRateValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.groupId)) {
        auto groupIdValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.groupId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "groupId"_s), groupIdValue);
    }
    if (!IDLLong::isNullValue(dictionary.height)) {
        auto heightValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.height));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "height"_s), heightValue);
    }
    if (!IDLLong::isNullValue(dictionary.sampleRate)) {
        auto sampleRateValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.sampleRate));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"_s), sampleRateValue);
    }
    if (!IDLLong::isNullValue(dictionary.sampleSize)) {
        auto sampleSizeValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.sampleSize));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleSize"_s), sampleSizeValue);
    }
    if (!IDLDouble::isNullValue(dictionary.volume)) {
        auto volumeValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.volume));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "volume"_s), volumeValue);
    }
    if (!IDLLong::isNullValue(dictionary.width)) {
        auto widthValue = toJS<IDLLong>(lexicalGlobalObject, throwScope, IDLLong::extractValueFromNullable(dictionary.width));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "width"_s), widthValue);
    }
    if (!IDLDouble::isNullValue(dictionary.zoom)) {
        auto zoomValue = toJS<IDLDouble>(lexicalGlobalObject, throwScope, IDLDouble::extractValueFromNullable(dictionary.zoom));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "zoom"_s), zoomValue);
    }
    return result;
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_clone);
static JSC_DECLARE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_stop);
static JSC_DECLARE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_getCapabilities);
static JSC_DECLARE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_getConstraints);
static JSC_DECLARE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_getSettings);
static JSC_DECLARE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_applyConstraints);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrackConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrack_kind);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrack_id);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrack_label);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrack_enabled);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaStreamTrack_enabled);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrack_contentHint);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaStreamTrack_contentHint);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrack_muted);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrack_onmute);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaStreamTrack_onmute);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrack_onunmute);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaStreamTrack_onunmute);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrack_onconfigurationchange);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaStreamTrack_onconfigurationchange);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrack_readyState);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaStreamTrack_onended);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaStreamTrack_onended);

class JSMediaStreamTrackPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaStreamTrackPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaStreamTrackPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaStreamTrackPrototype>(vm)) JSMediaStreamTrackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaStreamTrackPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaStreamTrackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaStreamTrackPrototype, JSMediaStreamTrackPrototype::Base);

using JSMediaStreamTrackDOMConstructor = JSDOMConstructorNotConstructable<JSMediaStreamTrack>;

template<> const ClassInfo JSMediaStreamTrackDOMConstructor::s_info = { "MediaStreamTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamTrackDOMConstructor) };

template<> JSValue JSMediaStreamTrackDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaStreamTrackDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaStreamTrack"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaStreamTrack::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSMediaStreamTrackPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrackConstructor, 0 } },
    { "kind"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrack_kind, 0 } },
    { "id"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrack_id, 0 } },
    { "label"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrack_label, 0 } },
    { "enabled"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrack_enabled, setJSMediaStreamTrack_enabled } },
    { "contentHint"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrack_contentHint, setJSMediaStreamTrack_contentHint } },
    { "muted"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrack_muted, 0 } },
    { "onmute"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrack_onmute, setJSMediaStreamTrack_onmute } },
    { "onunmute"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrack_onunmute, setJSMediaStreamTrack_onunmute } },
    { "onconfigurationchange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrack_onconfigurationchange, setJSMediaStreamTrack_onconfigurationchange } },
    { "readyState"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrack_readyState, 0 } },
    { "onended"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaStreamTrack_onended, setJSMediaStreamTrack_onended } },
    { "clone"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaStreamTrackPrototypeFunction_clone, 0 } },
    { "stop"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaStreamTrackPrototypeFunction_stop, 0 } },
    { "getCapabilities"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaStreamTrackPrototypeFunction_getCapabilities, 0 } },
    { "getConstraints"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaStreamTrackPrototypeFunction_getConstraints, 0 } },
    { "getSettings"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaStreamTrackPrototypeFunction_getSettings, 0 } },
    { "applyConstraints"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaStreamTrackPrototypeFunction_applyConstraints, 0 } },
};

const ClassInfo JSMediaStreamTrackPrototype::s_info = { "MediaStreamTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamTrackPrototype) };

void JSMediaStreamTrackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaStreamTrack::info(), JSMediaStreamTrackPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaStreamTrack::s_info = { "MediaStreamTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamTrack) };

JSMediaStreamTrack::JSMediaStreamTrack(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaStreamTrack>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, MediaStreamTrack>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSMediaStreamTrack::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaStreamTrackPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSMediaStreamTrackPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaStreamTrack::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaStreamTrack>(vm, globalObject);
}

JSValue JSMediaStreamTrack::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaStreamTrackDOMConstructor, DOMConstructorID::MediaStreamTrack>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrackConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaStreamTrackPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaStreamTrack::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsMediaStreamTrack_kindGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.kind())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrack_kind, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrack_kindGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaStreamTrack_idGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrack_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrack_idGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaStreamTrack_labelGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrack_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrack_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaStreamTrack_enabledGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.enabled())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrack_enabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrack_enabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaStreamTrack_enabledSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setEnabled(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaStreamTrack_enabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrack_enabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaStreamTrack_contentHintGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.contentHint())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrack_contentHint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrack_contentHintGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaStreamTrack_contentHintSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setContentHint(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaStreamTrack_contentHint, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrack_contentHintSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaStreamTrack_mutedGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.mutedForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrack_muted, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrack_mutedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaStreamTrack_onmuteGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().muteEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrack_onmute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrack_onmuteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaStreamTrack_onmuteSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().muteEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaStreamTrack_onmute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrack_onmuteSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaStreamTrack_onunmuteGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().unmuteEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrack_onunmute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrack_onunmuteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaStreamTrack_onunmuteSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().unmuteEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaStreamTrack_onunmute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrack_onunmuteSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaStreamTrack_onconfigurationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().configurationchangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrack_onconfigurationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrack_onconfigurationchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaStreamTrack_onconfigurationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().configurationchangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaStreamTrack_onconfigurationchange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrack_onconfigurationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaStreamTrack_readyStateGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<MediaStreamTrack::State>>(lexicalGlobalObject, throwScope, impl.readyState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrack_readyState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrack_readyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaStreamTrack_onendedGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaStreamTrack_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::get<jsMediaStreamTrack_onendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaStreamTrack_onendedSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamTrack& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.wrapped(), eventNames().endedEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaStreamTrack_onended, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaStreamTrack>::set<setJSMediaStreamTrack_onendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunction_cloneBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStreamTrack>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.clone())));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_clone, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunction_cloneBody>(*lexicalGlobalObject, *callFrame, "clone");
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunction_stopBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStreamTrack>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stopTrack(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_stop, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunction_stopBody>(*lexicalGlobalObject, *callFrame, "stop");
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunction_getCapabilitiesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStreamTrack>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<MediaTrackCapabilities>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getCapabilities())));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_getCapabilities, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunction_getCapabilitiesBody>(*lexicalGlobalObject, *callFrame, "getCapabilities");
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunction_getConstraintsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStreamTrack>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<MediaTrackConstraints>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getConstraints())));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_getConstraints, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunction_getConstraintsBody>(*lexicalGlobalObject, *callFrame, "getConstraints");
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunction_getSettingsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStreamTrack>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<MediaStreamTrack::TrackSettings>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getSettings())));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_getSettings, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunction_getSettingsBody>(*lexicalGlobalObject, *callFrame, "getSettings");
}

static inline JSC::EncodedJSValue jsMediaStreamTrackPrototypeFunction_applyConstraintsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaStreamTrack>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto constraints = convert<IDLDictionary<MediaTrackConstraints>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.applyConstraints(WTFMove(constraints), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaStreamTrackPrototypeFunction_applyConstraints, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSMediaStreamTrack>::call<jsMediaStreamTrackPrototypeFunction_applyConstraintsBody>(*lexicalGlobalObject, *callFrame, "applyConstraints");
}

JSC::GCClient::IsoSubspace* JSMediaStreamTrack::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaStreamTrack, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaStreamTrack.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaStreamTrack = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaStreamTrack.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaStreamTrack = std::forward<decltype(space)>(space); }
    );
}

void JSMediaStreamTrack::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaStreamTrack*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaStreamTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsMediaStreamTrack = jsCast<JSMediaStreamTrack*>(handle.slot()->asCell());
    auto& wrapped = jsMediaStreamTrack->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaStreamTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaStreamTrack = static_cast<JSMediaStreamTrack*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaStreamTrack->wrapped(), jsMediaStreamTrack);
}

MediaStreamTrack* JSMediaStreamTrack::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaStreamTrack*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM)
