/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.interpreter.JaninoRexCompiler;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.MetadataHandlerProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.metadata.UnboundMetadata;
import org.apache.calcite.rel.metadata.janino.RelMetadataHandlerGeneratorUtil;
import org.apache.calcite.util.Util;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.ICompilerFactory;
import org.codehaus.commons.compiler.ISimpleCompiler;

public class JaninoRelMetadataProvider
implements RelMetadataProvider,
MetadataHandlerProvider {
    private final RelMetadataProvider provider;
    public static final JaninoRelMetadataProvider DEFAULT = JaninoRelMetadataProvider.of(DefaultRelMetadataProvider.INSTANCE);
    private static final LoadingCache<Key, MetadataHandler<?>> HANDLERS = JaninoRelMetadataProvider.maxSize(CacheBuilder.newBuilder(), CalciteSystemProperty.METADATA_HANDLER_CACHE_MAXIMUM_SIZE.value()).build(CacheLoader.from(key -> JaninoRelMetadataProvider.generateCompileAndInstantiate(key.handlerClass, key.provider.handlers(key.handlerClass))));

    private JaninoRelMetadataProvider(RelMetadataProvider provider) {
        this.provider = provider;
    }

    public static JaninoRelMetadataProvider of(RelMetadataProvider provider) {
        if (provider instanceof JaninoRelMetadataProvider) {
            return (JaninoRelMetadataProvider)provider;
        }
        return new JaninoRelMetadataProvider(provider);
    }

    private static <K, V> CacheBuilder<K, V> maxSize(CacheBuilder<K, V> builder, int size) {
        if (size >= 0) {
            builder.maximumSize((long)size);
        }
        return builder;
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof JaninoRelMetadataProvider && ((JaninoRelMetadataProvider)obj).provider.equals(this.provider);
    }

    public int hashCode() {
        return 109 + this.provider.hashCode();
    }

    @Override
    @Deprecated
    public <M extends Metadata> UnboundMetadata<M> apply(Class<? extends RelNode> relClass, Class<? extends M> metadataClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public <M extends Metadata> Multimap<Method, MetadataHandler<M>> handlers(MetadataDef<M> def) {
        return this.provider.handlers(def);
    }

    @Override
    public List<MetadataHandler<?>> handlers(Class<? extends MetadataHandler<?>> handlerClass) {
        return this.provider.handlers(handlerClass);
    }

    private static <MH extends MetadataHandler<?>> MH generateCompileAndInstantiate(Class<MH> handlerClass, List<? extends MetadataHandler<? extends Metadata>> handlers) {
        List uniqueHandlers = handlers.stream().distinct().collect(Collectors.toList());
        RelMetadataHandlerGeneratorUtil.HandlerNameAndGeneratedCode handlerNameAndGeneratedCode = RelMetadataHandlerGeneratorUtil.generateHandler(handlerClass, uniqueHandlers);
        try {
            return JaninoRelMetadataProvider.compile(handlerNameAndGeneratedCode.getHandlerName(), handlerNameAndGeneratedCode.getGeneratedCode(), handlerClass, uniqueHandlers);
        }
        catch (IOException | CompileException e) {
            throw new RuntimeException("Error compiling:\n" + handlerNameAndGeneratedCode.getGeneratedCode(), e);
        }
    }

    static <MH extends MetadataHandler<?>> MH compile(String className, String generatedCode, Class<MH> handlerClass, List<? extends Object> argList) throws CompileException, IOException {
        Object o;
        ICompilerFactory compilerFactory;
        ClassLoader classLoader = Objects.requireNonNull(JaninoRelMetadataProvider.class.getClassLoader(), "classLoader");
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory((ClassLoader)classLoader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        ISimpleCompiler compiler = compilerFactory.newSimpleCompiler();
        compiler.setParentClassLoader(JaninoRexCompiler.class.getClassLoader());
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            compiler.setDebuggingInformation(true, true, true);
            System.out.println(generatedCode);
        }
        compiler.cook(generatedCode);
        try {
            Constructor<?> constructor = compiler.getClassLoader().loadClass(className).getDeclaredConstructors()[0];
            o = constructor.newInstance(argList.toArray());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return (MH)((MetadataHandler)handlerClass.cast(o));
    }

    public synchronized <H extends MetadataHandler<?>> H revise(Class<H> handlerClass) {
        try {
            Key key = new Key(handlerClass, this.provider);
            return (H)((MetadataHandler)handlerClass.cast(HANDLERS.get((Object)key)));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw Util.throwAsRuntime(Util.causeOrSelf(e));
        }
    }

    @Deprecated
    public void register(Iterable<Class<? extends RelNode>> classes) {
    }

    @Override
    public <MH extends MetadataHandler<?>> MH handler(Class<MH> handlerClass) {
        return (MH)((MetadataHandler)handlerClass.cast(Proxy.newProxyInstance(RelMetadataQuery.class.getClassLoader(), new Class[]{handlerClass}, (proxy, method, args) -> {
            RelNode r = Objects.requireNonNull((RelNode)args[0], "(RelNode) args[0]");
            throw new NoHandler(r.getClass());
        })));
    }

    @API(status=API.Status.INTERNAL)
    @VisibleForTesting
    public static void clearStaticCache() {
        HANDLERS.invalidateAll();
    }

    private static class Key {
        final Class<? extends MetadataHandler<? extends Metadata>> handlerClass;
        final RelMetadataProvider provider;

        private Key(Class<? extends MetadataHandler<?>> handlerClass, RelMetadataProvider provider) {
            this.handlerClass = handlerClass;
            this.provider = provider;
        }

        public int hashCode() {
            return (this.handlerClass.hashCode() * 37 + this.provider.hashCode()) * 37;
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Key && ((Key)obj).handlerClass.equals(this.handlerClass) && ((Key)obj).provider.equals(this.provider);
        }
    }

    @Deprecated
    public static class NoHandler
    extends MetadataHandlerProvider.NoHandler {
        public NoHandler(Class<? extends RelNode> relClass) {
            super(relClass);
        }
    }
}

