/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.bloom;

import org.apache.lucene.codecs.bloom.HashFunction;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;

public class MurmurHash64
extends HashFunction {
    private static final long M64 = -4132994306676758123L;
    private static final int R64 = 47;
    public static final HashFunction INSTANCE = new MurmurHash64();

    public static long hash64(byte[] data, int seed, int offset, int length) {
        long h = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int nblocks = length >> 3;
        for (int i = 0; i < nblocks; ++i) {
            long k = BitUtil.VH_LE_LONG.get(data, offset);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
            offset += 8;
        }
        int remaining = length & 7;
        if (0 < remaining) {
            for (int i = 0; i < remaining; ++i) {
                h ^= ((long)data[offset + i] & 0xFFL) << 8 * i;
            }
            h *= -4132994306676758123L;
        }
        h ^= h >>> 47;
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        return h;
    }

    @Override
    public final long hash(BytesRef br) {
        return MurmurHash64.hash64(br.bytes, -512093083, br.offset, br.length);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

