/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.bytecode;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.bytecode.BytecodeBuilder;
import com.oracle.truffle.api.bytecode.BytecodeConfig;
import com.oracle.truffle.api.bytecode.BytecodeConfigEncoder;
import com.oracle.truffle.api.bytecode.BytecodeParser;
import com.oracle.truffle.api.bytecode.serialization.BytecodeSerializer;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class BytecodeRootNodes<T extends RootNode> {
    protected static final Object TOKEN = new Object();
    private final BytecodeParser<? extends BytecodeBuilder> parser;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    protected T[] nodes;

    protected BytecodeRootNodes(Object token, BytecodeParser<? extends BytecodeBuilder> parser) {
        this.parser = parser;
        BytecodeRootNodes.checkToken(token);
    }

    static void checkToken(Object token) {
        if (token != TOKEN) {
            throw new IllegalArgumentException("Invalid usage token. Seriously, you shouldn't subclass this class manually.");
        }
    }

    public final List<T> getNodes() {
        return List.of(this.nodes);
    }

    public final T getNode(int i) {
        return this.nodes[i];
    }

    public final int count() {
        return this.nodes.length;
    }

    protected final BytecodeParser<? extends BytecodeBuilder> getParser() {
        return this.parser;
    }

    public final boolean update(BytecodeConfig config) {
        CompilerAsserts.partialEvaluationConstant(config);
        return this.updateImpl(config.encoder, config.encoding);
    }

    protected abstract boolean updateImpl(BytecodeConfigEncoder var1, long var2);

    public void serialize(DataOutput buffer, BytecodeSerializer callback) throws IOException {
        throw new IllegalArgumentException("Serialization is not enabled for this interpreter.");
    }

    public final boolean ensureSourceInformation() {
        return this.updateImpl(null, BytecodeConfig.WITH_SOURCE.encoding);
    }

    public final boolean ensureComplete() {
        return this.updateImpl(null, BytecodeConfig.COMPLETE.encoding);
    }

    public String toString() {
        return String.format("BytecodeNodes %s", Arrays.toString(this.nodes));
    }
}

