/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class TpSlotUnaryFunc {
    private TpSlotUnaryFunc() {
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class CallSlotUnaryPythonNode
    extends Node {
        CallSlotUnaryPythonNode() {
        }

        abstract Object execute(VirtualFrame var1, TpSlot.TpSlotPythonSingle var2, Object var3);

        @Specialization
        static Object doIt(VirtualFrame frame, TpSlot.TpSlotPythonSingle slot, Object self, @Bind Node inliningTarget, @Cached PythonDispatchers.UnaryPythonSlotDispatcherNode dispatcherNode) {
            return dispatcherNode.execute(frame, inliningTarget, slot.getCallable(), slot.getType(), self);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotUnaryNode
    extends Node {
        private static final TruffleString T_UNARY_SLOT = PythonUtils.tsLiteral("<unary slot>");
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "unaryfunc");

        public abstract Object execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4);

        @Specialization(guards={"cachedSlot == slot"}, limit="3")
        static Object callCachedBuiltin(VirtualFrame frame, TpSlotUnaryFuncBuiltin<?> slot, Object self, @Cached(value="slot") TpSlotUnaryFuncBuiltin<?> cachedSlot, @Cached(value="cachedSlot.createSlotNode()") PythonUnaryBuiltinNode slotNode) {
            return slotNode.execute(frame, self);
        }

        @Specialization
        static Object callPython(VirtualFrame frame, TpSlot.TpSlotPythonSingle slot, Object self, @Cached(inline=false) CallSlotUnaryPythonNode callSlotNode) {
            return callSlotNode.execute(frame, slot, self);
        }

        @Specialization
        static Object callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotCExtNative slot, Object self, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached(inline=false) ExternalFunctionNodes.PyObjectCheckFunctionResultNode checkResultNode) {
            PythonContext.PythonThreadState state = getThreadStateNode.execute(inliningTarget);
            Object result = externalInvokeNode.call(frame, inliningTarget, state, C_API_TIMING, T_UNARY_SLOT, slot.callable, toNativeNode.execute(self));
            return checkResultNode.execute(state, T_UNARY_SLOT, toPythonNode.execute(result));
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static Object callGenericBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotUnaryFuncBuiltin<?> slot, Object self, @Cached CallDispatchers.SimpleIndirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(1);
            PArguments.setArgument(arguments, 0, self);
            RootCallTarget callTarget = PythonLanguage.get(inliningTarget).getBuiltinSlotCallTarget(slot.callTargetIndex);
            return invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }
    }

    public static abstract class TpSlotUnaryFuncBuiltin<T extends PythonUnaryBuiltinNode>
    extends TpSlot.TpSlotBuiltinBase<T> {
        final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();
        private final String builtinName;

        protected TpSlotUnaryFuncBuiltin(NodeFactory<T> nodeFactory, String builtinName) {
            super(nodeFactory, BuiltinSlotWrapperSignature.UNARY, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC);
            this.builtinName = builtinName;
        }

        final PythonUnaryBuiltinNode createSlotNode() {
            return (PythonUnaryBuiltinNode)((Object)this.createNode());
        }

        @Override
        public final void initialize(PythonLanguage language) {
            RootCallTarget callTarget = TpSlotUnaryFuncBuiltin.createSlotCallTarget(language, BuiltinSlotWrapperSignature.UNARY, this.getNodeFactory(), this.builtinName);
            language.setBuiltinSlotCallTarget(this.callTargetIndex, callTarget);
        }
    }
}

