/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt.arc4;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfig;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionInitInfo;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPlugin;
import org.firebirdsql.gds.ng.wire.crypt.arc4.Arc4EncryptionPluginSpi;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public final class Arc4EncryptionPlugin
implements EncryptionPlugin {
    private static final String ARCFOUR_CIPHER_NAME = "ARCFOUR";
    private final CryptSessionConfig cryptSessionConfig;

    Arc4EncryptionPlugin(CryptSessionConfig cryptSessionConfig) {
        this.cryptSessionConfig = cryptSessionConfig;
    }

    @Override
    public EncryptionIdentifier getEncryptionIdentifier() {
        return Arc4EncryptionPluginSpi.ARC4_ID;
    }

    @Override
    public EncryptionInitInfo initializeEncryption() {
        SQLExceptionChainBuilder<SQLException> chainBuilder = new SQLExceptionChainBuilder<SQLException>();
        Cipher encryptionCipher = this.createEncryptionCipher(chainBuilder);
        Cipher decryptionCipher = this.createDecryptionCipher(chainBuilder);
        if (chainBuilder.hasException()) {
            return EncryptionInitInfo.failure(this.getEncryptionIdentifier(), chainBuilder.getException());
        }
        return EncryptionInitInfo.success(this.getEncryptionIdentifier(), encryptionCipher, decryptionCipher);
    }

    private Cipher createEncryptionCipher(SQLExceptionChainBuilder<SQLException> chainBuilder) {
        return this.createCipher(1, this.cryptSessionConfig.getEncryptKey(), chainBuilder);
    }

    private Cipher createDecryptionCipher(SQLExceptionChainBuilder<SQLException> chainBuilder) {
        return this.createCipher(2, this.cryptSessionConfig.getDecryptKey(), chainBuilder);
    }

    private Cipher createCipher(int mode, byte[] key, SQLExceptionChainBuilder<SQLException> chainBuilder) {
        try {
            return this.createCipher(mode, key);
        }
        catch (SQLException e) {
            chainBuilder.append(e);
            return null;
        }
    }

    private Cipher createCipher(int mode, byte[] key) throws SQLException {
        try {
            Cipher rc4Cipher = Cipher.getInstance(ARCFOUR_CIPHER_NAME);
            SecretKeySpec rc4Key = new SecretKeySpec(key, ARCFOUR_CIPHER_NAME);
            rc4Cipher.init(mode, rc4Key);
            return rc4Cipher;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new FbExceptionBuilder().nonTransientException(337248281).messageParameter(this.getEncryptionIdentifier().toString()).cause(e).toSQLException();
        }
        catch (InvalidKeyException e) {
            throw new FbExceptionBuilder().nonTransientException(337248282).messageParameter(this.getEncryptionIdentifier().toString()).cause(e).toSQLException();
        }
    }
}

