/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateInline
@GenerateCached(value=false)
@GenerateUncached
@ImportStatic(value={PGuards.class})
public abstract class PyLongCopy
extends Node {
    public abstract Object execute(Node var1, Object var2);

    @Specialization
    static int doB(boolean obj) {
        return obj ? 1 : 0;
    }

    @Specialization
    static int doI(int obj) {
        return obj;
    }

    @Specialization
    static long doL(long obj) {
        return obj;
    }

    @Specialization(guards={"isBuiltinPInt(obj)"})
    static PInt doPInt(PInt obj) {
        return obj;
    }

    @Specialization(guards={"!isBuiltinPInt(obj)"}, rewriteOn={OverflowException.class})
    static int doPIntOverridenNarrowInt(PInt obj) throws OverflowException {
        return obj.intValueExact();
    }

    @Specialization(guards={"!isBuiltinPInt(obj)"}, replaces={"doPIntOverridenNarrowInt"}, rewriteOn={OverflowException.class})
    static long doPIntOverridenNarrowLong(PInt obj) throws OverflowException {
        return obj.longValueExact();
    }

    @Specialization(guards={"!isBuiltinPInt(obj)"}, replaces={"doPIntOverridenNarrowLong"})
    static PInt doPIntOverriden(PInt obj, @Bind PythonLanguage language) {
        return PFactory.createInt(language, obj.getValue());
    }

    @Specialization
    static PythonNativeVoidPtr doL(PythonNativeVoidPtr obj) {
        return obj;
    }
}

