/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;

public class ConnectionPoolDataSourceConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    static final String CLASS_NAME = ConnectionPoolDataSourceConnectionFactoryAdapter.class.getName();
    protected ConnectionPoolDataSource m_connectionPoolDataSource;
    protected final ReentrantLock connectionPoolDataSourceLock = new ReentrantLock();

    public ConnectionPoolDataSourceConnectionFactoryAdapter(ConnectionPoolDataSource connectionPoolDataSource, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(diagnosticsCollector);
        if (null == connectionPoolDataSource) {
            UCPErrorHandler.throwUniversalConnectionPoolException(251);
        }
        this.m_connectionPoolDataSource = connectionPoolDataSource;
    }

    public ConnectionPoolDataSourceConnectionFactoryAdapter(ConnectionPoolDataSource connectionPoolDataSource) throws UniversalConnectionPoolException {
        this(connectionPoolDataSource, DiagnosticsCollectorImpl.getCommon());
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.m_connectionPoolDataSource;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRequestInfo;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionPoolDataSourceConnectionFactoryAdapter", "createConnection", "entering args ({0})", null, null, connectionRetrievalInfo);
            if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(252);
            }
            JDBCConnectionRetrievalInfo jdbcConnectionRequestInfo = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
            PooledConnection pooledConnection = null;
            try {
                pooledConnection = this.m_connectionPoolDataSource.getPooledConnection(jdbcConnectionRequestInfo.getUser(), jdbcConnectionRequestInfo.getPassword().get());
                UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
                if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
                    pooledConnection.addConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
                }
                this.onSuccessfulConnectionCreation(pooledConnection);
            }
            catch (Throwable e) {
                this.onFailedConnectionCreation(e);
                this.trace(Level.WARNING, CLASS_NAME, "createConnection", "", null, e, new Object[0]);
                if (null != pooledConnection) {
                    this.closeConnection(pooledConnection);
                }
                UCPErrorHandler.throwUniversalConnectionPoolException(253, e);
            }
            PooledConnection pooledConnection2 = pooledConnection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionPoolDataSourceConnectionFactoryAdapter", "createConnection", "returning {0}", null, null, pooledConnection2);
            return pooledConnection2;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionPoolDataSourceConnectionFactoryAdapter", "createConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void closeConnection(Object object) throws UniversalConnectionPoolException {
        try {
            void connection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionPoolDataSourceConnectionFactoryAdapter", "closeConnection", "entering args ({0})", null, null, object);
            if (!(connection instanceof PooledConnection)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(254);
            }
            PooledConnection pooledConnection = (PooledConnection)connection;
            UniversalConnectionPool connectionPool = this.getUniversalConnectionPool();
            if (connectionPool != null && connectionPool instanceof ConnectionEventListener) {
                pooledConnection.removeConnectionEventListener((ConnectionEventListener)((Object)connectionPool));
            }
            try {
                pooledConnection.close();
            }
            catch (SQLException sqlException) {
                this.trace(Level.WARNING, CLASS_NAME, "closeConnection", "", null, sqlException, new Object[0]);
                UCPErrorHandler.throwUniversalConnectionPoolException(255, sqlException);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionPoolDataSourceConnectionFactoryAdapter", "closeConnection", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.ConnectionPoolDataSourceConnectionFactoryAdapter", "closeConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }
}

