/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.filmInformation;

import com.formdev.flatlaf.util.ScaledImageIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.time.LocalDate;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import mediathek.daten.DatenFilm;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.filmInformation.DisabledCheckBox;
import mediathek.gui.filmInformation.FilmAvailableUntilWorker;
import mediathek.gui.filmInformation.HtmlMultilineLabel;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.CopyToClipboardAction;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.SwingErrorDialog;
import mediathek.tool.datum.DateUtil;
import mediathek.tool.sender_icon_cache.MVSenderIconCache;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.jdesktop.swingx.JXHyperlink;

public class FilmInfoDialog
extends JDialog {
    private static final Dimension DEFAULT_SENDER_DIMENSION = new Dimension(64, 64);
    private final JPopupMenu popupMenu = new JPopupMenu();
    private Optional<DatenFilm> currentFilmOptional = Optional.empty();
    private FilmAvailableUntilWorker currentWorker;
    private JLabel lblSender;
    private HtmlMultilineLabel lblThema;
    private HtmlMultilineLabel lblTitel;
    private JLabel lblDate;
    private JLabel lblUhrzeit;
    private JLabel lblDuration;
    private JLabel lblSize;
    private DisabledCheckBox cbHq;
    private DisabledCheckBox cbSubtitle;
    private JLabel lblSeason;
    private JLabel lblEpisode;
    private JLabel lblAvailableUntil;
    private JLabel lblGeo;
    private JLabel lblAbo;
    private JXHyperlink hyperlink;
    private JScrollPane descScrollPane;
    private JTextPane lblDescription;

    public FilmInfoDialog(Window owner) {
        super(owner);
        this.initComponents();
        this.setupDescriptionPopupMenu();
        this.setupHyperlink();
        this.updateTextFields();
        this.restoreLocation();
        this.setVisible(ApplicationConfiguration.getConfiguration().getBoolean("film.information.visible", false));
        this.setupListeners();
    }

    private void setupDescriptionPopupMenu() {
        JMenuItem item = new JMenuItem("Auswahl kopieren");
        item.addActionListener(actionEvent -> {
            boolean selected;
            boolean bl = selected = this.lblDescription.getSelectionEnd() - this.lblDescription.getSelectionStart() > 0;
            if (!selected) {
                JOptionPane.showMessageDialog(this, "Kein Text markiert!", "MediathekView", 0);
            } else {
                GuiFunktionen.copyToClipboard(this.lblDescription.getSelectedText());
            }
        });
        this.popupMenu.add(item);
        this.lblDescription.setComponentPopupMenu(this.popupMenu);
    }

    private void setupListeners() {
        this.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowOpened(WindowEvent e) {
                ApplicationConfiguration.getConfiguration().setProperty("film.information.visible", (Object)true);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                ApplicationConfiguration.getConfiguration().setProperty("film.information.visible", (Object)false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FilmInfoDialog.this.saveLocation();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if (FilmInfoDialog.this.isVisible()) {
                    FilmInfoDialog.this.saveLocation();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreLocation() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        config.lock(LockMode.READ);
        try {
            Point newLocation = new Point(config.getInt("film.information.location.x"), config.getInt("film.information.location.y"));
            this.setLocation(newLocation);
            int w = config.getInt("film.information.location.width");
            int h = config.getInt("film.information.location.height");
            if (w > 50 && h > 50) {
                this.setSize(new Dimension(w, h));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private void saveLocation() {
        if (!this.isVisible()) {
            return;
        }
        Configuration config = ApplicationConfiguration.getConfiguration();
        config.lock(LockMode.WRITE);
        try {
            Point location = this.getLocationOnScreen();
            config.setProperty("film.information.location.x", (Object)location.x);
            config.setProperty("film.information.location.y", (Object)location.y);
            config.setProperty("film.information.location.width", (Object)this.getWidth());
            config.setProperty("film.information.location.height", (Object)this.getHeight());
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }

    private void setupHyperlink() {
        this.hyperlink.addActionListener(actionEvent -> {
            if (!this.hyperlink.getToolTipText().isEmpty()) {
                String toolTipText = this.hyperlink.getToolTipText();
                if (Desktop.isDesktopSupported()) {
                    Desktop d = Desktop.getDesktop();
                    if (d.isSupported(Desktop.Action.BROWSE)) {
                        try {
                            d.browse(new URI(toolTipText));
                        }
                        catch (Exception ex) {
                            SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Es trat ein Fehler beim \u00d6ffnen des Links auf.\nSollte dies h\u00e4ufiger auftreten kontaktieren Sie bitte das Entwicklerteam.", ex);
                        }
                    } else {
                        UrlHyperlinkAction.openURL(toolTipText);
                    }
                } else {
                    UrlHyperlinkAction.openURL(toolTipText);
                }
            }
        });
    }

    public void showInfo() {
        this.updateTextFields();
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    public void updateCurrentFilm(DatenFilm film) {
        this.currentFilmOptional = film == null ? Optional.empty() : Optional.of(film);
        if (this.isVisible()) {
            this.updateTextFields();
        }
    }

    private void clearControls() {
        this.lblSender.setText("");
        this.lblThema.setText("");
        this.lblTitel.setText("");
        this.lblDate.setText("");
        this.lblUhrzeit.setText("");
        this.lblDuration.setText("");
        this.lblSize.setText("");
        this.lblGeo.setText("");
        this.cbHq.setSelected(false);
        this.cbSubtitle.setSelected(false);
        this.lblAbo.setText("");
        this.hyperlink.setToolTipText("");
        this.hyperlink.setEnabled(false);
        this.hyperlink.setComponentPopupMenu(null);
        this.lblDescription.setText("");
        this.lblSeason.setText("");
        this.lblEpisode.setText("");
        this.lblAvailableUntil.setText("");
    }

    private void updateTextFields() {
        this.currentFilmOptional.ifPresentOrElse(currentFilm -> {
            LocalDate availableUntil;
            MVSenderIconCache.get(currentFilm.getSender()).ifPresentOrElse(icon -> {
                this.lblSender.setText("");
                Dimension imageDim = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                Dimension destDim = GuiFunktionen.calculateFittedDimension(imageDim, DEFAULT_SENDER_DIMENSION);
                this.lblSender.setIcon((Icon)new ScaledImageIcon(icon, destDim.width, destDim.height));
            }, () -> this.lblSender.setText(currentFilm.getSender()));
            this.lblThema.setText(currentFilm.getThema());
            this.lblTitel.setText(currentFilm.getTitle());
            this.lblDate.setText(currentFilm.getSendeDatum());
            this.lblUhrzeit.setText(currentFilm.getSendeZeit());
            this.lblDuration.setText(currentFilm.getFilmLengthAsString());
            this.lblSize.setText(currentFilm.getFileSize().toString());
            if (currentFilm.countrySet.isEmpty()) {
                this.lblGeo.setText("");
            } else {
                String txt = currentFilm.countrySet.stream().map(Enum::toString).collect(Collectors.joining("-"));
                this.lblGeo.setText(txt);
            }
            this.cbHq.setSelected(currentFilm.isHighQuality());
            this.cbSubtitle.setSelected(currentFilm.hasSubtitle());
            currentFilm.getAboOptional().ifPresentOrElse(abo -> this.lblAbo.setText(abo.getName()), () -> this.lblAbo.setText(""));
            this.prepareHyperlink(currentFilm.getWebsiteUrl());
            this.lblDescription.setText(currentFilm.getDescription().trim());
            SwingUtilities.invokeLater(() -> this.descScrollPane.getVerticalScrollBar().setValue(0));
            if (currentFilm.getSeason() != 0) {
                this.lblSeason.setText(String.valueOf(currentFilm.getSeason()));
            } else {
                this.lblSeason.setText("");
            }
            if (currentFilm.getEpisode() != 0) {
                this.lblEpisode.setText(String.valueOf(currentFilm.getEpisode()));
            } else {
                this.lblEpisode.setText("");
            }
            if (this.currentWorker != null && !this.currentWorker.isDone()) {
                this.currentWorker.cancel(true);
            }
            if ((availableUntil = currentFilm.getAvailableUntil()) == null) {
                this.currentWorker = new FilmAvailableUntilWorker((DatenFilm)currentFilm, this.lblAvailableUntil);
                this.currentWorker.execute();
            } else {
                this.lblAvailableUntil.setText(DateUtil.FORMATTER.format(availableUntil));
            }
        }, this::clearControls);
    }

    private void prepareHyperlink(String url) {
        this.hyperlink.setEnabled(true);
        this.hyperlink.setToolTipText(url);
        this.hyperlink.setClicked(false);
        JPopupMenu urlPopupMenu = new JPopupMenu();
        urlPopupMenu.add(new CopyToClipboardAction(url));
        this.hyperlink.setComponentPopupMenu(urlPopupMenu);
    }

    private void initComponents() {
        JLabel label1 = new JLabel();
        this.lblSender = new JLabel();
        JLabel label2 = new JLabel();
        this.lblThema = new HtmlMultilineLabel();
        JLabel label3 = new JLabel();
        this.lblTitel = new HtmlMultilineLabel();
        JLabel label4 = new JLabel();
        this.lblDate = new JLabel();
        JLabel label5 = new JLabel();
        this.lblUhrzeit = new JLabel();
        JLabel label6 = new JLabel();
        this.lblDuration = new JLabel();
        JLabel label7 = new JLabel();
        this.lblSize = new JLabel();
        JLabel label8 = new JLabel();
        this.cbHq = new DisabledCheckBox();
        JLabel label9 = new JLabel();
        this.cbSubtitle = new DisabledCheckBox();
        JLabel label12 = new JLabel();
        this.lblSeason = new JLabel();
        JLabel label14 = new JLabel();
        this.lblEpisode = new JLabel();
        JLabel label15 = new JLabel();
        this.lblAvailableUntil = new JLabel();
        JLabel label10 = new JLabel();
        this.lblGeo = new JLabel();
        JLabel label11 = new JLabel();
        this.lblAbo = new JLabel();
        this.hyperlink = new JXHyperlink();
        JLabel label13 = new JLabel();
        this.descScrollPane = new JScrollPane();
        this.lblDescription = new JTextPane();
        this.setType(Window.Type.UTILITY);
        this.setTitle("Filminformation");
        this.setMaximumSize(new Dimension(500, 800));
        this.setMinimumSize(new Dimension(320, 240));
        this.setPreferredSize(new Dimension(400, 500));
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3), new AC().fill().gap().grow().fill(), new AC().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap().gap().grow().fill()));
        label1.setText("Sender:");
        contentPane.add((Component)label1, new CC().cell(new int[]{0, 0}));
        contentPane.add((Component)this.lblSender, new CC().cell(new int[]{1, 0}));
        label2.setText("Thema:");
        contentPane.add((Component)label2, new CC().cell(new int[]{0, 1}));
        this.lblThema.setPreferredSize(new Dimension(443, 32));
        this.lblThema.setMinimumSize(new Dimension(51, 32));
        contentPane.add((Component)this.lblThema, new CC().cell(new int[]{1, 1}));
        label3.setText("Titel:");
        contentPane.add((Component)label3, new CC().cell(new int[]{0, 2}));
        contentPane.add((Component)this.lblTitel, new CC().cell(new int[]{1, 2}));
        label4.setText("Datum:");
        contentPane.add((Component)label4, new CC().cell(new int[]{0, 3}));
        this.lblDate.setText("text");
        contentPane.add((Component)this.lblDate, new CC().cell(new int[]{1, 3}));
        label5.setText("Uhrzeit:");
        contentPane.add((Component)label5, new CC().cell(new int[]{0, 4}));
        this.lblUhrzeit.setText("text");
        contentPane.add((Component)this.lblUhrzeit, new CC().cell(new int[]{1, 4}));
        label6.setText("Dauer:");
        contentPane.add((Component)label6, new CC().cell(new int[]{0, 5}));
        this.lblDuration.setText("text");
        contentPane.add((Component)this.lblDuration, new CC().cell(new int[]{1, 5}));
        label7.setText("Gr\u00f6\u00dfe (MB):");
        contentPane.add((Component)label7, new CC().cell(new int[]{0, 6}));
        this.lblSize.setText("text");
        contentPane.add((Component)this.lblSize, new CC().cell(new int[]{1, 6}));
        label8.setText("HQ:");
        contentPane.add((Component)label8, new CC().cell(new int[]{0, 7}));
        contentPane.add((Component)this.cbHq, new CC().cell(new int[]{1, 7}));
        label9.setText("Untertitel:");
        contentPane.add((Component)label9, new CC().cell(new int[]{0, 8}));
        contentPane.add((Component)this.cbSubtitle, new CC().cell(new int[]{1, 8}));
        label12.setText("Season:");
        contentPane.add((Component)label12, new CC().cell(new int[]{0, 9}));
        this.lblSeason.setText("text");
        contentPane.add((Component)this.lblSeason, new CC().cell(new int[]{1, 9}).growX());
        label14.setText("Episode:");
        contentPane.add((Component)label14, new CC().cell(new int[]{0, 10}));
        this.lblEpisode.setText("text");
        contentPane.add((Component)this.lblEpisode, new CC().cell(new int[]{1, 10}).growX());
        label15.setText("Verf\u00fcgbar bis:");
        contentPane.add((Component)label15, new CC().cell(new int[]{0, 11}));
        this.lblAvailableUntil.setText("text");
        contentPane.add((Component)this.lblAvailableUntil, new CC().cell(new int[]{1, 11}));
        label10.setText("Geo:");
        contentPane.add((Component)label10, new CC().cell(new int[]{0, 12}));
        this.lblGeo.setText("text");
        contentPane.add((Component)this.lblGeo, new CC().cell(new int[]{1, 12}));
        label11.setText("Abo:");
        contentPane.add((Component)label11, new CC().cell(new int[]{0, 13}));
        this.lblAbo.setText("text");
        contentPane.add((Component)this.lblAbo, new CC().cell(new int[]{1, 13}));
        this.hyperlink.setText("Link zur Website");
        contentPane.add((Component)this.hyperlink, new CC().cell(new int[]{0, 14, 2, 1}));
        label13.setText("Beschreibung:");
        contentPane.add((Component)label13, new CC().cell(new int[]{0, 15, 2, 1}));
        this.lblDescription.setMinimumSize(new Dimension(1, 100));
        this.lblDescription.setPreferredSize(new Dimension(1, 100));
        this.lblDescription.setMaximumSize(new Dimension(Integer.MAX_VALUE, 200));
        this.descScrollPane.setViewportView(this.lblDescription);
        contentPane.add((Component)this.descScrollPane, new CC().cell(new int[]{0, 16, 2, 1}));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

