/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.expiration;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mediathek.gui.expiration.ExpiryInfo;
import mediathek.tool.http.MVHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class ArdMediathekExpiryHelper {
    private static final Pattern AVAILABLE_UNTIL_PATTERN = Pattern.compile("Video verf\u00fcgbar:.*?bis\\s*(\\d{2}\\.\\d{2}\\.\\d{4})\\s*\u2219\\s*(\\d{2}:\\d{2})\\s*Uhr", 32);
    private static final Logger LOG = LogManager.getLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<ExpiryInfo> getExpiryInfo(String url) {
        Request request = new Request.Builder().url(url).get().header("User-Agent", "Mozilla/5.0").build();
        try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();){
            if (response.isSuccessful()) {
                Document doc = Jsoup.parse(response.body().string());
                String body = doc.body().text();
                Matcher m = AVAILABLE_UNTIL_PATTERN.matcher(body);
                if (!m.find()) return Optional.empty();
                String date = m.group(1);
                LocalDate ld = LocalDate.parse(date, DateTimeFormatter.ofPattern("dd.MM.yyyy"));
                Optional<ExpiryInfo> optional = Optional.of(new ExpiryInfo(ld));
                return optional;
            }
            LOG.error("Could not fetch expiry data from {}", (Object)url);
            return Optional.empty();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }
}

