/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class TriangleSet extends Base {

	public TriangleSet(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * sets the name of the triangle set
	 *
	 * @param name the new name
	 * @throws Lib3MFException
	 */
	public void setName(String name) throws Lib3MFException {
		byte[] bytesName = name.getBytes(StandardCharsets.UTF_8);
		Memory bufferName = new Memory(bytesName.length + 1);
		bufferName.write(0, bytesName, 0, bytesName.length);
		bufferName.setByte(bytesName.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_setname.invokeInt(new java.lang.Object[]{mHandle, bufferName}));
	}

	/**
	 * returns the name of the triangle set
	 *
	 * @return returns the name
	 * @throws Lib3MFException
	 */
	public String getName() throws Lib3MFException {
		Pointer bytesNeededName = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_getname.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededName, null}));
		int sizeName = bytesNeededName.getInt(0);
		Pointer bufferName = new Memory(sizeName);
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_getname.invokeInt(new java.lang.Object[]{mHandle, sizeName, bytesNeededName, bufferName}));
		return new String(bufferName.getByteArray(0, sizeName - 1), StandardCharsets.UTF_8);
	}

	/**
	 * sets the identifier of the triangle set.
	 *
	 * @param identifier the new identifier. MUST be unique within the mesh. MUST NOT be an empty string
	 * @throws Lib3MFException
	 */
	public void setIdentifier(String identifier) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_setidentifier.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier}));
	}

	/**
	 * returns the identifier of the triangle set
	 *
	 * @return returns the identifier
	 * @throws Lib3MFException
	 */
	public String getIdentifier() throws Lib3MFException {
		Pointer bytesNeededIdentifier = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_getidentifier.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededIdentifier, null}));
		int sizeIdentifier = bytesNeededIdentifier.getInt(0);
		Pointer bufferIdentifier = new Memory(sizeIdentifier);
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_getidentifier.invokeInt(new java.lang.Object[]{mHandle, sizeIdentifier, bytesNeededIdentifier, bufferIdentifier}));
		return new String(bufferIdentifier.getByteArray(0, sizeIdentifier - 1), StandardCharsets.UTF_8);
	}

	/**
	 * adds a triangle to the set. Does nothing if triangle is already in the set.
	 *
	 * @param triangleIndex Triangle index to add. MUST be between 0 and TriangleCount - 1.
	 * @throws Lib3MFException
	 */
	public void addTriangle(int triangleIndex) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_addtriangle.invokeInt(new java.lang.Object[]{mHandle, triangleIndex}));
	}

	/**
	 * removes a triangle from the set
	 *
	 * @param triangleIndex Triangle index to remove. MUST be between 0 and TriangleCount - 1.
	 * @throws Lib3MFException
	 */
	public void removeTriangle(int triangleIndex) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_removetriangle.invokeInt(new java.lang.Object[]{mHandle, triangleIndex}));
	}

	/**
	 * clears all triangles from the list
	 *
	 * @throws Lib3MFException
	 */
	public void clear() throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_clear.invokeInt(new java.lang.Object[]{mHandle}));
	}

	/**
	 * Sets all triangles in the list, while clearing old values. Duplicates will be merged.
	 *
	 * @param triangleIndices Triangle indices to add. Every element MUST be between 0 and TriangleCount - 1.
	 * @throws Lib3MFException
	 */
	public void setTriangleList(int[] triangleIndices) throws Lib3MFException {
		Pointer bufferTriangleIndices = new Memory(Math.max(1, 4 * triangleIndices.length));
		for (int i = 0; i < triangleIndices.length; i++) {
		  bufferTriangleIndices.setInt(4 * i, triangleIndices[i]);
		}
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_settrianglelist.invokeInt(new java.lang.Object[]{mHandle, (long) triangleIndices.length, bufferTriangleIndices}));
	}

	/**
	 * Retrieves all the triangles in the TriangleSet
	 *
	 * @return retrieves the indices of the triangles in this TriangleSet
	 * @throws Lib3MFException
	 */
	public int[] getTriangleList() throws Lib3MFException {
		Pointer countNeededTriangleIndices = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_gettrianglelist.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededTriangleIndices, Pointer.NULL}));
		long countTriangleIndices = countNeededTriangleIndices.getLong(0);
		Pointer bufferTriangleIndices = new Memory(Math.max(1, 4 * countTriangleIndices));
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_gettrianglelist.invokeInt(new java.lang.Object[]{mHandle, countTriangleIndices, countNeededTriangleIndices, bufferTriangleIndices}));
		return bufferTriangleIndices.getIntArray(0, (int)countTriangleIndices);
	}

	/**
	 * Adds multiple triangles in the list. Duplicates will be merged.
	 *
	 * @param triangleIndices Triangle indices to add. Every element MUST be between 0 and TriangleCount - 1.
	 * @throws Lib3MFException
	 */
	public void addTriangleList(int[] triangleIndices) throws Lib3MFException {
		Pointer bufferTriangleIndices = new Memory(Math.max(1, 4 * triangleIndices.length));
		for (int i = 0; i < triangleIndices.length; i++) {
		  bufferTriangleIndices.setInt(4 * i, triangleIndices[i]);
		}
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_addtrianglelist.invokeInt(new java.lang.Object[]{mHandle, (long) triangleIndices.length, bufferTriangleIndices}));
	}

	/**
	 * Merges another Triangle set.
	 *
	 * @param otherTriangleSet Other triangle set to merge.
	 * @param deleteOther Flag if other triangle set is getting removed.
	 * @throws Lib3MFException
	 */
	public void merge(TriangleSet otherTriangleSet, boolean deleteOther) throws Lib3MFException {
		Pointer otherTriangleSetHandle = null;
		if (otherTriangleSet != null) {
			otherTriangleSetHandle = otherTriangleSet.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "OtherTriangleSet is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_merge.invokeInt(new java.lang.Object[]{mHandle, otherTriangleSetHandle, deleteOther}));
	}

	/**
	 * Deletes the whole set from the mesh.
	 *
	 * @throws Lib3MFException
	 */
	public void deleteSet() throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_deleteset.invokeInt(new java.lang.Object[]{mHandle}));
	}

	/**
	 * Duplicates the set in the mesh.
	 *
	 * @param identifier the new identifier. MUST be unique within the mesh. MUST NOT be an empty string
	 * @return Copy of the triangle set.
	 * @throws Lib3MFException
	 */
	public TriangleSet duplicate(String identifier) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		Pointer bufferNewSet = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_triangleset_duplicate.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier, bufferNewSet}));
		Pointer valueNewSet = bufferNewSet.getPointer(0);
		TriangleSet newSet = null;
		if (valueNewSet == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "NewSet was a null pointer");
		}
		newSet = mWrapper.PolymorphicFactory(valueNewSet, TriangleSet.class);
		return newSet;
	}


}

