/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class MetaDataGroup extends Base {

	public MetaDataGroup(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * returns the number of metadata in this metadatagroup
	 *
	 * @return returns the number metadata
	 * @throws Lib3MFException
	 */
	public int getMetaDataCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_metadatagroup_getmetadatacount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}

	/**
	 * returns a metadata value within this metadatagroup
	 *
	 * @param index Index of the Metadata.
	 * @return an instance of the metadata
	 * @throws Lib3MFException
	 */
	public MetaData getMetaData(int index) throws Lib3MFException {
		Pointer bufferMetaData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_metadatagroup_getmetadata.invokeInt(new java.lang.Object[]{mHandle, index, bufferMetaData}));
		Pointer valueMetaData = bufferMetaData.getPointer(0);
		MetaData metaData = null;
		if (valueMetaData == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "MetaData was a null pointer");
		}
		metaData = mWrapper.PolymorphicFactory(valueMetaData, MetaData.class);
		return metaData;
	}

	/**
	 * returns a metadata value within this metadatagroup
	 *
	 * @param nameSpace the namespace of the metadata
	 * @param name the name of the Metadata
	 * @return an instance of the metadata
	 * @throws Lib3MFException
	 */
	public MetaData getMetaDataByKey(String nameSpace, String name) throws Lib3MFException {
		byte[] bytesNameSpace = nameSpace.getBytes(StandardCharsets.UTF_8);
		Memory bufferNameSpace = new Memory(bytesNameSpace.length + 1);
		bufferNameSpace.write(0, bytesNameSpace, 0, bytesNameSpace.length);
		bufferNameSpace.setByte(bytesNameSpace.length, (byte)0);
		byte[] bytesName = name.getBytes(StandardCharsets.UTF_8);
		Memory bufferName = new Memory(bytesName.length + 1);
		bufferName.write(0, bytesName, 0, bytesName.length);
		bufferName.setByte(bytesName.length, (byte)0);
		Pointer bufferMetaData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_metadatagroup_getmetadatabykey.invokeInt(new java.lang.Object[]{mHandle, bufferNameSpace, bufferName, bufferMetaData}));
		Pointer valueMetaData = bufferMetaData.getPointer(0);
		MetaData metaData = null;
		if (valueMetaData == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "MetaData was a null pointer");
		}
		metaData = mWrapper.PolymorphicFactory(valueMetaData, MetaData.class);
		return metaData;
	}

	/**
	 * removes metadata by index from the model.
	 *
	 * @param index  Index of the metadata to remove
	 * @throws Lib3MFException
	 */
	public void removeMetaDataByIndex(int index) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_metadatagroup_removemetadatabyindex.invokeInt(new java.lang.Object[]{mHandle, index}));
	}

	/**
	 * removes metadata from the model.
	 *
	 * @param theMetaData The metadata to remove
	 * @throws Lib3MFException
	 */
	public void removeMetaData(MetaData theMetaData) throws Lib3MFException {
		Pointer theMetaDataHandle = null;
		if (theMetaData != null) {
			theMetaDataHandle = theMetaData.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheMetaData is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_metadatagroup_removemetadata.invokeInt(new java.lang.Object[]{mHandle, theMetaDataHandle}));
	}

	/**
	 * adds a new metadata to this metadatagroup
	 *
	 * @param nameSpace the namespace of the metadata
	 * @param name the name of the metadata
	 * @param value the value of the metadata
	 * @param type the type of the metadata
	 * @param mustPreserve should the metadata be preserved
	 * @return a new instance of the metadata
	 * @throws Lib3MFException
	 */
	public MetaData addMetaData(String nameSpace, String name, String value, String type, boolean mustPreserve) throws Lib3MFException {
		byte[] bytesNameSpace = nameSpace.getBytes(StandardCharsets.UTF_8);
		Memory bufferNameSpace = new Memory(bytesNameSpace.length + 1);
		bufferNameSpace.write(0, bytesNameSpace, 0, bytesNameSpace.length);
		bufferNameSpace.setByte(bytesNameSpace.length, (byte)0);
		byte[] bytesName = name.getBytes(StandardCharsets.UTF_8);
		Memory bufferName = new Memory(bytesName.length + 1);
		bufferName.write(0, bytesName, 0, bytesName.length);
		bufferName.setByte(bytesName.length, (byte)0);
		byte[] bytesValue = value.getBytes(StandardCharsets.UTF_8);
		Memory bufferValue = new Memory(bytesValue.length + 1);
		bufferValue.write(0, bytesValue, 0, bytesValue.length);
		bufferValue.setByte(bytesValue.length, (byte)0);
		byte[] bytesType = type.getBytes(StandardCharsets.UTF_8);
		Memory bufferType = new Memory(bytesType.length + 1);
		bufferType.write(0, bytesType, 0, bytesType.length);
		bufferType.setByte(bytesType.length, (byte)0);
		Pointer bufferMetaData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_metadatagroup_addmetadata.invokeInt(new java.lang.Object[]{mHandle, bufferNameSpace, bufferName, bufferValue, bufferType, mustPreserve, bufferMetaData}));
		Pointer valueMetaData = bufferMetaData.getPointer(0);
		MetaData metaData = null;
		if (valueMetaData == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "MetaData was a null pointer");
		}
		metaData = mWrapper.PolymorphicFactory(valueMetaData, MetaData.class);
		return metaData;
	}


}

