/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.AbstractDomainPath;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.CollectionPartPath;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPath;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPathContinuation;
import org.hibernate.metamodel.mapping.ordering.ast.FkDomainPathContinuation;
import org.hibernate.metamodel.mapping.ordering.ast.SequencePart;
import org.hibernate.spi.NavigablePath;

public class PluralAttributePath
extends AbstractDomainPath {
    private final NavigablePath navigablePath;
    private final PluralAttributeMapping pluralAttributeMapping;

    PluralAttributePath(PluralAttributeMapping pluralAttributeMapping) {
        this.navigablePath = new NavigablePath(pluralAttributeMapping.getRootPathName());
        this.pluralAttributeMapping = pluralAttributeMapping;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public DomainPath getLhs() {
        return null;
    }

    @Override
    public PluralAttributeMapping getReferenceModelPart() {
        return this.pluralAttributeMapping;
    }

    @Override
    public SequencePart resolvePathPart(String name, String identifier, boolean isTerminal, TranslationContext translationContext) {
        EmbeddableValuedModelPart indexDescriptor;
        ModelPart indexSubPart;
        EmbeddableValuedModelPart elementDescriptor;
        ModelPart elementSubPart;
        ModelPart subPart = this.pluralAttributeMapping.findSubPart(name, null);
        if (subPart != null) {
            if (subPart instanceof CollectionPart) {
                CollectionPart collectionPart = (CollectionPart)subPart;
                return new CollectionPartPath(this, collectionPart);
            }
            if (subPart instanceof EmbeddableValuedModelPart) {
                return new DomainPathContinuation(this.navigablePath.append(name), this, subPart);
            }
            if (subPart instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping toOneMapping = (ToOneAttributeMapping)subPart;
                return new FkDomainPathContinuation(this.navigablePath.append(name), (DomainPath)this, toOneMapping);
            }
            return new CollectionPartPath(this, this.pluralAttributeMapping.getElementDescriptor()).resolvePathPart(name, identifier, isTerminal, translationContext);
        }
        CollectionPart toOneMapping = this.pluralAttributeMapping.getElementDescriptor();
        if (toOneMapping instanceof EmbeddableValuedModelPart && (elementSubPart = (elementDescriptor = (EmbeddableValuedModelPart)((Object)toOneMapping)).findSubPart(name, null)) != null) {
            return new DomainPathContinuation(new CollectionPartPath(this, (CollectionPart)((Object)elementDescriptor)).getNavigablePath().append(name), this, elementSubPart);
        }
        elementSubPart = this.pluralAttributeMapping.getIndexDescriptor();
        if (elementSubPart instanceof EmbeddableValuedModelPart && (indexSubPart = (indexDescriptor = (EmbeddableValuedModelPart)elementSubPart).findSubPart(name, null)) != null) {
            return new DomainPathContinuation(new CollectionPartPath(this, (CollectionPart)((Object)indexDescriptor)).getNavigablePath().append(name), this, indexSubPart);
        }
        return null;
    }
}

