/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.function.DateTruncEmulation;
import org.hibernate.dialect.function.TruncFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleTruncFunction
extends TruncFunction {
    private final DateTruncEmulation dateTruncEmulation;

    public OracleTruncFunction(TypeConfiguration typeConfiguration) {
        super("trunc(?1)", "trunc(?1,?2)", TruncFunction.DatetimeTrunc.TRUNC, null, typeConfiguration);
        this.dateTruncEmulation = new DateTruncEmulation("to_date", typeConfiguration);
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        ArgumentTypesValidator argumentsValidator;
        TruncFunction.TruncRenderingSupport renderer;
        ArrayList args = new ArrayList(arguments);
        if (arguments.size() == 2 && arguments.get(1) instanceof SqmExtractUnit) {
            String pattern;
            renderer = this.datetimeRenderingSupport;
            argumentsValidator = TruncFunction.TruncArgumentsValidator.DATETIME_VALIDATOR;
            TemporalUnit temporalUnit = ((SqmExtractUnit)arguments.get(1)).getUnit();
            switch (temporalUnit) {
                case YEAR: {
                    pattern = "YYYY";
                    break;
                }
                case MONTH: {
                    pattern = "MM";
                    break;
                }
                case WEEK: {
                    pattern = "IW";
                    break;
                }
                case DAY: {
                    pattern = "DD";
                    break;
                }
                case HOUR: {
                    pattern = "HH";
                    break;
                }
                case MINUTE: {
                    pattern = "MI";
                    break;
                }
                case SECOND: {
                    return this.dateTruncEmulation.generateSqmFunctionExpression(arguments, impliedResultType, queryEngine);
                }
                default: {
                    throw new UnsupportedOperationException("Temporal unit not supported [" + String.valueOf((Object)temporalUnit) + "]");
                }
            }
            args.set(1, new SqmLiteral<String>(pattern, queryEngine.getTypeConfiguration().getBasicTypeForJavaType(String.class), queryEngine.getCriteriaBuilder()));
        } else {
            renderer = this.numericRenderingSupport;
            argumentsValidator = TruncFunction.TruncArgumentsValidator.NUMERIC_VALIDATOR;
        }
        return new SelfRenderingSqmFunction<T>(this, renderer, args, impliedResultType, argumentsValidator, this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }
}

