/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.process.AbstractExecutionException;
import java.nio.file.Path;
import java.util.List;

public class ProcessExecutionException
extends AbstractExecutionException {
    private static final long serialVersionUID = -6038501979928698849L;
    private long pid = -1L;
    private Path command = null;
    private List<String> arguments = List.of();
    private boolean showCommand;

    public ProcessExecutionException() {
    }

    public ProcessExecutionException(String msg) {
        super(msg);
    }

    public ProcessExecutionException(Throwable cause) {
        super(cause);
    }

    public ProcessExecutionException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public long pid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public Path command() {
        return this.command;
    }

    public void setCommand(Path command) {
        this.command = (Path)Assert.checkNotNullParam((String)"command", (Object)command);
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = List.copyOf(arguments);
    }

    public boolean showCommand() {
        return this.showCommand;
    }

    public void setShowCommand(boolean showCommand) {
        this.showCommand = showCommand;
    }

    @Override
    public StringBuilder getMessage(StringBuilder sb) {
        super.getMessage(sb);
        if (this.showCommand && this.command != null) {
            sb.append(" for command \"").append(this.command).append('\"');
            if (!this.arguments.isEmpty()) {
                this.arguments.forEach(arg -> sb.append(",\"").append((String)arg).append('\"'));
            }
        }
        if (this.pid != -1L) {
            sb.append(" (pid ").append(this.pid).append(')');
        }
        return sb;
    }
}

