/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.IdentityProviderCapability;

public enum IdentityProviderType {
    ANY(new IdentityProviderCapability[0]),
    USER_AUTHENTICATION(IdentityProviderCapability.USER_LINKING),
    CLIENT_ASSERTION(new IdentityProviderCapability[0]),
    EXCHANGE_EXTERNAL_TOKEN(IdentityProviderCapability.USER_LINKING),
    JWT_AUTHORIZATION_GRANT(IdentityProviderCapability.USER_LINKING);

    private final Set<IdentityProviderCapability> capabilities;

    private IdentityProviderType(IdentityProviderCapability ... capabilities) {
        this.capabilities = capabilities == null || capabilities.length == 0 ? Collections.emptySet() : Arrays.stream(capabilities).collect(Collectors.toSet());
    }

    public Set<IdentityProviderCapability> getCapabilities() {
        return this.capabilities;
    }
}

