/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.network.SocketServer$;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerConfigHandler;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.DynamicLogConfig$;
import kafka.server.DynamicRemoteLogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.DynamicThreadPool;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.apache.kafka.storage.internals.log.LogCleaner;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.SetOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;
import scala.util.matching.Regex;

public final class DynamicBrokerConfig$ {
    public static final DynamicBrokerConfig$ MODULE$ = new DynamicBrokerConfig$();
    private static final scala.collection.mutable.Set<String> DynamicSecurityConfigs = CollectionConverters$.MODULE$.SetHasAsScala(SslConfigs.RECONFIGURABLE_CONFIGS).asScala();
    private static final Set<String> DynamicProducerStateManagerConfig = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"producer.id.expiration.ms", "transaction.partition.verification.enable"}));
    private static final scala.collection.mutable.Set<String> AllDynamicConfigs = (scala.collection.mutable.Set)MODULE$.DynamicSecurityConfigs().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(LogCleaner.RECONFIGURABLE_CONFIGS).asScala()).$plus$plus(DynamicLogConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(DynamicThreadPool.RECONFIGURABLE_CONFIGS).asScala()).$plus$plus((IterableOnce)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"metric.reporters"}))).$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(SocketServer$.MODULE$.ReconfigurableConfigs()).$plus$plus(MODULE$.DynamicProducerStateManagerConfig()).$plus$plus(DynamicRemoteLogConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus((IterableOnce)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"config.providers"})));
    private static final Set<String> ClusterLevelListenerConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max.connections", "max.connection.creation.rate", "num.network.threads"}));
    private static final scala.collection.mutable.Set<String> PerBrokerConfigs = (scala.collection.mutable.Set)((SetOps)MODULE$.DynamicSecurityConfigs().$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs())).diff(MODULE$.ClusterLevelListenerConfigs());
    private static final Set<String> ListenerMechanismConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sasl.jaas.config", "sasl.login.callback.handler.class", "sasl.login.class", "sasl.server.callback.handler.class", "connections.max.reauth.ms"}));
    private static final Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.truststore.location"}));
    private static final Regex ListenerConfigRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("listener\\.name\\.[^.]*\\.(.*)"));

    public scala.collection.mutable.Set<String> DynamicSecurityConfigs() {
        return DynamicSecurityConfigs;
    }

    public Set<String> DynamicProducerStateManagerConfig() {
        return DynamicProducerStateManagerConfig;
    }

    public scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return AllDynamicConfigs;
    }

    private Set<String> ClusterLevelListenerConfigs() {
        return ClusterLevelListenerConfigs;
    }

    private scala.collection.mutable.Set<String> PerBrokerConfigs() {
        return PerBrokerConfigs;
    }

    private Set<String> ListenerMechanismConfigs() {
        return ListenerMechanismConfigs;
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs() {
        return kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    }

    private Regex ListenerConfigRegex() {
        return ListenerConfigRegex;
    }

    public List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        Option option;
        String string = ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG;
        if (!(string != null ? !string.equals(name) : name != null) ? true : "log.roll.hours".equals(name)) {
            return new .colon.colon((Object)ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG, (List)new .colon.colon((Object)"log.roll.hours", (List)Nil$.MODULE$));
        }
        String string2 = ServerLogConfigs.LOG_ROLL_TIME_JITTER_MILLIS_CONFIG;
        if (!(string2 != null ? !string2.equals(name) : name != null) ? true : "log.roll.jitter.hours".equals(name)) {
            return new .colon.colon((Object)ServerLogConfigs.LOG_ROLL_TIME_JITTER_MILLIS_CONFIG, (List)new .colon.colon((Object)"log.roll.jitter.hours", (List)Nil$.MODULE$));
        }
        String string3 = ServerLogConfigs.LOG_FLUSH_INTERVAL_MS_CONFIG;
        if (!(string3 != null ? !string3.equals(name) : name != null)) {
            return new .colon.colon((Object)ServerLogConfigs.LOG_FLUSH_INTERVAL_MS_CONFIG, (List)new .colon.colon((Object)"log.flush.scheduler.interval.ms", (List)Nil$.MODULE$));
        }
        String string4 = ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG;
        if (!(string4 != null ? !string4.equals(name) : name != null) ? true : ("log.retention.minutes".equals(name) ? true : "log.retention.hours".equals(name))) {
            return new .colon.colon((Object)ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, (List)new .colon.colon((Object)"log.retention.minutes", (List)new .colon.colon((Object)"log.retention.hours", (List)Nil$.MODULE$)));
        }
        if (name != null && !(option = this.ListenerConfigRegex().unapplySeq((CharSequence)name)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOps)option.get()).apply(0);
            if (matchListenerOverride) {
                Option mechanismConfig = this.ListenerMechanismConfigs().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)baseName.endsWith(x$1)));
                return new .colon.colon((Object)name, (List)new .colon.colon((Object)((String)mechanismConfig.getOrElse((Function0 & Serializable)() -> baseName)), (List)Nil$.MODULE$));
            }
        }
        return new .colon.colon((Object)name, (List)Nil$.MODULE$);
    }

    public void validateConfigs(Properties props, boolean perBrokerConfig) {
        DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Cannot update these configs dynamically");
        DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "These security configs can be dynamically updated only per-listener using the listener prefix");
        this.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
        if (!perBrokerConfig) {
            DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Cannot update these configs at default cluster level, broker id must be specified");
            return;
        }
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$perBrokerConfigs(Properties props) {
        Set configNames = CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().keySet();
        return (Set)configNames.intersect(this.PerBrokerConfigs()).$plus$plus((IterableOnce)configNames.filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)this.perBrokerListenerConfig$1(name))));
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(Properties props) {
        return (Set)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().keySet().intersect(DynamicConfig$Broker$.MODULE$.nonDynamicProps());
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(Properties props) {
        return (Set)this.DynamicSecurityConfigs().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)props.containsKey(x$1)));
    }

    public void kafka$server$DynamicBrokerConfig$$validateConfigTypes(Properties props) {
        Properties baseProps = new Properties();
        CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Option option;
                String string = (String)x0$1._1();
                String v = (String)x0$1._2();
                if (string != null && !(option = MODULE$.ListenerConfigRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                    String baseName = (String)((LinearSeqOps)option.get()).apply(0);
                    return baseProps.put(baseName, v);
                }
            }
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return baseProps.put(k, v);
            }
            throw new MatchError(null);
        });
        DynamicConfig$Broker$.MODULE$.validate(baseProps);
    }

    public java.util.Map<String, String> dynamicConfigUpdateModes() {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)this.AllDynamicConfigs().map((Function1 & Serializable)name -> {
            String mode = MODULE$.PerBrokerConfigs().contains(name) ? "per-broker" : "cluster-wide";
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)mode);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public Properties resolveVariableConfigs(Properties propsOriginal) {
        Properties props = new Properties();
        new AbstractConfig(new ConfigDef(), (java.util.Map)propsOriginal, Utils.castToStringObjectMap((java.util.Map)propsOriginal), false).originals().forEach((key, value) -> {
            if (!key.startsWith("config.providers")) {
                props.put(key, value);
                return;
            }
        });
        return props;
    }

    public void readDynamicBrokerConfigsFromSnapshot(KafkaRaftManager<ApiMessageAndVersion> raftManager, KafkaConfig config, QuotaFactory.QuotaManagers quotaManagers, LogContext logContext) {
        raftManager.replicatedLog().latestSnapshotId().ifPresent(latestSnapshotId -> raftManager.replicatedLog().readSnapshot(latestSnapshotId).ifPresent(rawSnapshotReader -> Using$.MODULE$.resource((Object)RecordsSnapshotReader.of((RawSnapshotReader)rawSnapshotReader, raftManager.recordSerde(), (BufferSupplier)BufferSupplier.create(), (int)0x800000, (boolean)true, (LogContext)logContext), (Function1 & Serializable)reader -> {
            DynamicBrokerConfig$.$anonfun$readDynamicBrokerConfigsFromSnapshot$3(config, quotaManagers, reader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$)));
    }

    private static final void checkInvalidProps$1(Set invalidPropNames, String errorMessage) {
        if (invalidPropNames.nonEmpty()) {
            throw new ConfigException(errorMessage + ": " + invalidPropNames);
        }
    }

    private final boolean perBrokerListenerConfig$1(String name) {
        Option option;
        if (name != null && !(option = this.ListenerConfigRegex().unapplySeq((CharSequence)name)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOps)option.get()).apply(0);
            return !this.ClusterLevelListenerConfigs().contains((Object)baseName);
        }
        return false;
    }

    private static final void putOrRemoveIfNull$1(Properties props, String key, String value) {
        if (value == null) {
            props.remove(key);
            return;
        }
        props.put(key, value);
    }

    public static final /* synthetic */ void $anonfun$readDynamicBrokerConfigsFromSnapshot$3(KafkaConfig config$1, QuotaFactory.QuotaManagers quotaManagers$1, RecordsSnapshotReader reader) {
        Properties dynamicPerBrokerConfigs = new Properties();
        Properties dynamicDefaultConfigs = new Properties();
        while (reader.hasNext()) {
            reader.next().forEach(record -> {
                block6: {
                    block7: {
                        block10: {
                            ConfigRecord configRecord;
                            block9: {
                                String string;
                                String string2;
                                block8: {
                                    if (record.message().apiKey() != MetadataRecordType.CONFIG_RECORD.id()) break block6;
                                    configRecord = (ConfigRecord)record.message();
                                    if (!MODULE$.AllDynamicConfigs().contains((Object)configRecord.name()) || configRecord.resourceType() != ConfigResource.Type.BROKER.id()) break block7;
                                    if (configRecord.resourceName().isEmpty()) {
                                        DynamicBrokerConfig$.putOrRemoveIfNull$1(dynamicDefaultConfigs, configRecord.name(), configRecord.value());
                                        return;
                                    }
                                    string2 = configRecord.resourceName();
                                    string = Integer.toString(config$1.brokerId());
                                    if (string2 != null) break block8;
                                    if (string != null) {
                                        return;
                                    }
                                    break block9;
                                }
                                if (!string2.equals(string)) break block10;
                            }
                            DynamicBrokerConfig$.putOrRemoveIfNull$1(dynamicPerBrokerConfigs, configRecord.name(), configRecord.value());
                            return;
                        }
                        return;
                    }
                    return;
                }
            });
        }
        BrokerConfigHandler configHandler = new BrokerConfigHandler(config$1, quotaManagers$1);
        configHandler.processConfigChanges("", dynamicDefaultConfigs);
        configHandler.processConfigChanges(Integer.toString(config$1.brokerId()), dynamicPerBrokerConfigs);
    }

    private DynamicBrokerConfig$() {
    }
}

