/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmMissingBuiltInDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "checkers.jvm"})
public final class FirJvmMissingBuiltInDeclarationChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirJvmMissingBuiltInDeclarationChecker INSTANCE = new FirJvmMissingBuiltInDeclarationChecker();

    private FirJvmMissingBuiltInDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression2) {
        FirRegularClassSymbol returnTypeClassSymbol;
        FirClassLikeSymbol<?> containingClass;
        FirBasedSymbol<?> resolvedReferenceSymbol;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getSuppressMissingBuiltinsError()).booleanValue()) {
            return;
        }
        if (expression2 instanceof FirResolvedQualifier && FirJvmMissingBuiltInDeclarationChecker.check$reportIfNeeded(context2, reporter, expression2, ((FirResolvedQualifier)expression2).getSymbol())) {
            return;
        }
        FirReference firReference = ReferenceUtilsKt.toReference(expression2, context2.getSession());
        FirBasedSymbol<?> firBasedSymbol = resolvedReferenceSymbol = firReference != null && (firReference = FirReferenceUtilsKt.getResolved(firReference)) != null ? FirReferenceUtilsKt.getSymbol(firReference) : null;
        FirClassLikeSymbol<Object> firClassLikeSymbol = containingClass = firBasedSymbol != null ? FirHelpersKt.getContainingClassSymbol(firBasedSymbol) : null;
        if (FirJvmMissingBuiltInDeclarationChecker.check$reportIfNeeded(context2, reporter, expression2, containingClass)) {
            return;
        }
        if (resolvedReferenceSymbol instanceof FirCallableSymbol && FirJvmMissingBuiltInDeclarationChecker.check$reportIfNeeded(context2, reporter, expression2, returnTypeClassSymbol = FirHelpersKt.toRegularClassSymbol(((FirCallableSymbol)resolvedReferenceSymbol).getResolvedReturnTypeRef(), context2.getSession()))) {
            return;
        }
    }

    private static final boolean check$reportIfNeeded(CheckerContext $context, DiagnosticReporter $reporter, FirStatement $expression, FirClassLikeSymbol<?> classSymbol) {
        FirClassLikeSymbol<?> firClassLikeSymbol = classSymbol;
        if (Intrinsics.areEqual((Object)(firClassLikeSymbol != null ? firClassLikeSymbol.getOrigin() : null), (Object)FirDeclarationOrigin.BuiltInsFallback.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)$expression.getSource(), FirJvmErrors.INSTANCE.getMISSING_BUILT_IN_DECLARATION(), classSymbol, null, 16, null);
            return true;
        }
        return false;
    }
}

