/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { EventEmitter } from 'node:events';
import { type WebSocket } from 'ws';
import type { NetworkLog, ConsoleLogPayload } from './types.js';
export type { NetworkLog, ConsoleLogPayload, InspectorConsoleLog, } from './types.js';
interface IncomingNetworkPayload extends Partial<NetworkLog> {
    chunk?: {
        index: number;
        data: string;
        timestamp: number;
    };
}
export interface SessionInfo {
    sessionId: string;
    ws: WebSocket;
    lastPing: number;
}
/**
 * DevTools Viewer
 *
 * Receives logs via WebSocket from CLI sessions.
 */
export declare class DevTools extends EventEmitter {
    private static instance;
    private logs;
    private consoleLogs;
    private server;
    private wss;
    private sessions;
    private heartbeatTimer;
    private port;
    private constructor();
    static getInstance(): DevTools;
    addInternalConsoleLog(payload: ConsoleLogPayload, sessionId?: string, timestamp?: number): void;
    addInternalNetworkLog(payload: IncomingNetworkPayload, sessionId?: string, timestamp?: number): void;
    getUrl(): string;
    getPort(): number;
    stop(): Promise<void>;
    start(): Promise<string>;
    private setupWebSocketServer;
    private handleWebSocketMessage;
}
