/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import java.io.ObjectStreamException;
import javax.swing.Icon;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.icon.button.MaximizeIcon;

public final class MaximizeWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final MaximizeWindowAction INSTANCE = new MaximizeWindowAction();
    private static final Icon icon = new MaximizeIcon(10);

    private MaximizeWindowAction() {
    }

    @Override
    public Icon getIcon() {
        return icon;
    }

    @Override
    public String getName() {
        return "Maximize";
    }

    @Override
    public boolean isPerformable(DockingWindow window) {
        if (!window.isMaximizable()) {
            return false;
        }
        TabWindow tabWindow = DockingUtil.getTabWindowFor(window);
        return tabWindow != null && !tabWindow.isMaximized() && tabWindow.isMaximizable();
    }

    @Override
    public void perform(DockingWindow window) {
        TabWindow tabWindow = DockingUtil.getTabWindowFor(window);
        if (tabWindow != null && !tabWindow.isMaximized() && tabWindow.isMaximizable()) {
            tabWindow.maximize();
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

