/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.edit;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.ai.edits.AIEdits;

public class AiEditsMarker {
    public void addAiEditsMarkerWithUndo(final NodeModel nodeModel) {
        if (nodeModel == null || nodeModel.isHiddenSummary()) {
            return;
        }
        if (nodeModel.getExtension(AIEdits.class) != null) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        if (controller == null || controller.getModeController() == null) {
            nodeModel.addExtension((IExtension)new AIEdits());
            return;
        }
        final MapController mapController = controller.getModeController().getMapController();
        IActor actor = new IActor(){

            public void act() {
                AIEdits aiEdits = new AIEdits();
                nodeModel.addExtension((IExtension)aiEdits);
                mapController.nodeChanged(nodeModel, AIEdits.class, null, (Object)aiEdits);
            }

            public void undo() {
                AIEdits aiEdits = (AIEdits)nodeModel.getExtension(AIEdits.class);
                if (aiEdits == null) {
                    return;
                }
                nodeModel.removeExtension(AIEdits.class);
                mapController.nodeChanged(nodeModel, AIEdits.class, (Object)aiEdits, null);
            }

            public String getDescription() {
                return "add ai edits marker";
            }
        };
        controller.getModeController().execute(actor, nodeModel.getMap());
    }
}

