﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>
#include <aws/workspaces/model/AccountLink.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkSpaces {
namespace Model {
class ListAccountLinksResult {
 public:
  AWS_WORKSPACES_API ListAccountLinksResult() = default;
  AWS_WORKSPACES_API ListAccountLinksResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACES_API ListAccountLinksResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Information about the account links.</p>
   */
  inline const Aws::Vector<AccountLink>& GetAccountLinks() const { return m_accountLinks; }
  template <typename AccountLinksT = Aws::Vector<AccountLink>>
  void SetAccountLinks(AccountLinksT&& value) {
    m_accountLinksHasBeenSet = true;
    m_accountLinks = std::forward<AccountLinksT>(value);
  }
  template <typename AccountLinksT = Aws::Vector<AccountLink>>
  ListAccountLinksResult& WithAccountLinks(AccountLinksT&& value) {
    SetAccountLinks(std::forward<AccountLinksT>(value));
    return *this;
  }
  template <typename AccountLinksT = AccountLink>
  ListAccountLinksResult& AddAccountLinks(AccountLinksT&& value) {
    m_accountLinksHasBeenSet = true;
    m_accountLinks.emplace_back(std::forward<AccountLinksT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to use to retrieve the next page of results. This value is null
   * when there are no more results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAccountLinksResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListAccountLinksResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<AccountLink> m_accountLinks;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_accountLinksHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
