#!/usr/bin/python

from zita_jacktools.jackfwplay import *
from zita_jacktools.jackfwcapt import *
from zita_jacktools.jackpeaklim import JackPeaklim

# Copy file with 5 dB gain and peak limiting.

# Change to whatever you have available...
INPFILE = '/data/audio/audiofiles/tracks/still_crazy.wav'
OUTFILE = 'peaklim.wav'

P = JackFwplay (4, 'P')
C = JackFwcapt (4, 'C')
C.connect_sync ('P')

# Here we use the jacktools version of zita-dpl1.
L = JackPeaklim (2, 'L')
L.set_inpgain (5.0)
L.set_threshold (-0.5)

L.connect_input (0, 'P:out_0')
L.connect_input (1, 'P:out_1')
C.connect_input (0, 'L:out_0')
C.connect_input (1, 'L:out_1')

P.load_file (INPFILE)
C.create_file (OUTFILE, 2, 'wav,16bit')

P.process ()
print ("DONE")



