#!/usr/bin/python

# ----------------------------------------------------------------------------
#
#  Copyright (C) 2008-2022 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


import numpy as np
from time import sleep
from zita_jacktools.jackplayer import JackPlayer


# Same as playfile1.py, but using JackPlayer.
# This will resample to the Jack sample rate if necessary.
# Skip 10 seconds then play 20 seconds of a stereo audio file.


P = JackPlayer (2, "Player")
if P.get_state () < 0:
    print ("Failed to create JackPlayer -- is the server running ?")
    exit (1)

P.connect_output (0, "system:playback_1")
P.connect_output (1, "system:playback_2")

# Replace by your favourite track...
#
if P.open_file ("/audio/audiofiles/tracks/susheela_raman-maya.wav"):
    print ("Failed to open audio file.")
    exit (1)

name, fsjack, period = P.get_jack_info ()
chan, fsfile, lenght = P.get_file_info ()

if fsjack != fsfile:
    print ("Resampling %d -> %d." % (fsfile, fsjack))

P.stop ()
P.set_gain (-20) # dB
P.locate (10 * fsfile)
P.play ()
while True:
    state, posit = P.get_position ()
    if state < JackPlayer.PLAYING or state == JackPlayer.ENDFILE or posit >= 30 * fsfile: break
    sleep (0.1)
P.stop ()
P.silence ()
P.close_file ()
del P

