/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface MethodElement
extends MemberElement {
    @NonNull
    public ClassElement getReturnType();

    default public List<? extends GenericPlaceholderElement> getDeclaredTypeVariables() {
        return Collections.emptyList();
    }

    default public Optional<ClassElement> getReceiverType() {
        return Optional.empty();
    }

    @NonNull
    default public ClassElement[] getThrownTypes() {
        return ClassElement.ZERO_CLASS_ELEMENTS;
    }

    @NonNull
    public ParameterElement[] getParameters();

    @NonNull
    public MethodElement withNewParameters(ParameterElement ... var1);

    @NonNull
    default public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
        throw new UnsupportedOperationException("Only classes being processed from source code can define associated beans");
    }

    @NonNull
    default public ParameterElement[] getSuspendParameters() {
        return this.getParameters();
    }

    default public boolean hasParameters() {
        return this.getParameters().length > 0;
    }

    default public boolean isSuspend() {
        return false;
    }

    default public boolean isDefault() {
        return false;
    }

    @NonNull
    default public ClassElement getGenericReturnType() {
        return this.getReturnType();
    }

    @Override
    @NonNull
    default public String getDescription(boolean simple) {
        String typeString = simple ? this.getReturnType().getSimpleName() : this.getReturnType().getName();
        String args = Arrays.stream(this.getParameters()).map(arg -> simple ? arg.getType().getSimpleName() : arg.getType().getName() + " " + arg.getName()).collect(Collectors.joining(","));
        return typeString + " " + this.getName() + "(" + args + ")";
    }

    default public boolean overrides(@NonNull MethodElement overridden) {
        return false;
    }

    @NonNull
    public static MethodElement of(final @NonNull ClassElement declaredType, final @NonNull AnnotationMetadata annotationMetadata, final @NonNull ClassElement returnType, final @NonNull ClassElement genericReturnType, final @NonNull String name, final ParameterElement ... parameterElements) {
        return new MethodElement(){

            @Override
            @NonNull
            public ClassElement getReturnType() {
                return returnType;
            }

            @Override
            @NonNull
            public ClassElement getGenericReturnType() {
                return genericReturnType;
            }

            @Override
            public ParameterElement[] getParameters() {
                return parameterElements;
            }

            @Override
            public MethodElement withNewParameters(ParameterElement ... newParameters) {
                return MethodElement.of(declaredType, annotationMetadata, returnType, genericReturnType, name, (ParameterElement[])ArrayUtils.concat((Object[])parameterElements, (Object[])newParameters));
            }

            @NonNull
            public AnnotationMetadata getAnnotationMetadata() {
                return annotationMetadata;
            }

            @Override
            public ClassElement getDeclaringType() {
                return declaredType;
            }

            @Override
            @NonNull
            public String getName() {
                return name;
            }

            @Override
            public boolean isPackagePrivate() {
                return false;
            }

            @Override
            public boolean isProtected() {
                return false;
            }

            @Override
            public boolean isPublic() {
                return true;
            }

            @Override
            @NonNull
            public Object getNativeType() {
                throw new UnsupportedOperationException("No native method type present");
            }
        };
    }
}

