bats_load_library bats-support
bats_load_library bats-assert
load ../lib/common

@test "remove single packages" {
	local arches=('i686' 'x86_64')
	local pkgs=('pkg-simple-a' 'pkg-simple-b' 'pkg-split-a' 'pkg-split-b' 'pkg-simple-epoch')
	local pkgbase
	local arch

	for pkgbase in "${pkgs[@]}"; do
		releasePackage extra "${pkgbase}"
	done

	db-update

	for pkgbase in "${pkgs[@]}"; do
		for arch in ${arches[@]}; do
			db-remove extra "${arch}" "${pkgbase}"
		done
	done

	for pkgbase in "${pkgs[@]}"; do
		checkRemovedPackage extra "${pkgbase}"
	done
}

@test "remove multiple packages" {
	local arches=('i686' 'x86_64')
	local pkgs=('pkg-simple-a' 'pkg-simple-b' 'pkg-split-a' 'pkg-split-b' 'pkg-simple-epoch')
	local pkgbase
	local arch

	for pkgbase in "${pkgs[@]}"; do
		releasePackage extra "${pkgbase}"
	done

	db-update

	for arch in ${arches[@]}; do
		db-remove extra "${arch}" "${pkgs[@]}"
	done

	for pkgbase in "${pkgs[@]}"; do
		checkRemovedPackage extra "${pkgbase}"
	done
}

@test "remove partial split package explicitly" {
	local arches=('i686' 'x86_64')
	local arch

	releasePackage extra pkg-split-a
	db-update

	for arch in ${arches[@]}; do
		db-remove extra "${arch}" pkgname=pkg-split-a1
		if bsdtar xfO "$FTP_BASE/extra/os/$arch/extra.db" pkg-split-a1-1-1/desc >/dev/null; then return 1; fi
		   bsdtar xfO "$FTP_BASE/extra/os/$arch/extra.db" pkg-split-a2-1-1/desc >/dev/null
	done
}

@test "remove partial split package implicitly fails" {
	local arches=('i686' 'x86_64')
	local arch

	releasePackage extra pkg-split-a
	db-update

	for arch in ${arches[@]}; do
		db-remove extra "${arch}" pkg-split-a1
		bsdtar xfO "$FTP_BASE/extra/os/x86_64/extra.db" pkg-split-a1-1-1/desc >/dev/null
		bsdtar xfO "$FTP_BASE/extra/os/x86_64/extra.db" pkg-split-a2-1-1/desc >/dev/null
	done
}

@test "remove split multilib package" {
	db-init

	releasePackage extra pkg-split-multilib
	db-update

	assert bsdtar xfO "$FTP_BASE/extra/os/i686/extra.db"         pkg-split-multilib-1-1/desc >/dev/null
	assert bsdtar xfO "$FTP_BASE/extra/os/x86_64/extra.db"       pkg-split-multilib-1-1/desc >/dev/null
	assert bsdtar xfO "$FTP_BASE/extra/os/x86_64/extra.db" lib32-pkg-split-multilib-1-1/desc >/dev/null

	db-remove extra any pkg-split-multilib

	refute bsdtar xfO "$FTP_BASE/extra/os/i686/extra.db"         pkg-split-multilib-1-1/desc >/dev/null
	refute bsdtar xfO "$FTP_BASE/extra/os/x86_64/extra.db"       pkg-split-multilib-1-1/desc >/dev/null
	refute bsdtar xfO "$FTP_BASE/extra/os/x86_64/extra.db" lib32-pkg-split-multilib-1-1/desc >/dev/null
}

@test "remove any packages" {
	local pkgs=('pkg-any-a' 'pkg-any-b')
	local pkgbase

	for pkgbase in "${pkgs[@]}"; do
		releasePackage extra "${pkgbase}"
	done

	db-update

	for pkgbase in "${pkgs[@]}"; do
		db-remove extra any "${pkgbase}"
	done

	for pkgbase in "${pkgs[@]}"; do
		checkRemovedPackage extra "${pkgbase}"
	done
}
