/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.languagetool.JLanguageTool;
import org.languagetool.server.AbTestService;
import org.languagetool.server.HTTPServerConfig;

public class LocalAbTestService
implements AbTestService {
    protected LocalAbTestService() {
    }

    @Override
    public List<String> getActiveAbTestForClient(Map<String, String> params, HTTPServerConfig config) {
        List abTest = null;
        String agent = params.getOrDefault("useragent", "unknown");
        String paramActivatedAbTest = params.get("abtest");
        Pattern abTestClients = config.getAbTestClients();
        if (paramActivatedAbTest != null && abTestClients != null && abTestClients.matcher(agent).matches()) {
            String[] abParams = paramActivatedAbTest.trim().split(",");
            ArrayList<String> tmpAb = new ArrayList<String>();
            for (String abParam : abParams) {
                if (!config.getAbTest().contains(abParam)) continue;
                tmpAb.add(abParam.trim());
            }
            if (!tmpAb.isEmpty()) {
                abTest = Collections.unmodifiableList(tmpAb);
            }
        }
        return abTest;
    }

    public static AbTestService getAbTestService() {
        String className = "org.languagetool.server.PremiumAbTestService";
        try {
            Class aClass = JLanguageTool.getClassBroker().forName(className);
            Constructor constructor = aClass.getConstructor(new Class[0]);
            return (AbTestService)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return new LocalAbTestService();
        }
        catch (Exception e) {
            throw new RuntimeException("Object for class '" + className + "' could not be created", e);
        }
    }
}

