/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AdditionalField {
    private String key;
    private String value = "";

    public AdditionalField() {
    }

    public AdditionalField(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public static List<AdditionalField> parse(String additionalFields) {
        if (additionalFields == null) {
            return Collections.emptyList();
        }
        String[] split = additionalFields.split(",");
        ArrayList<AdditionalField> result = new ArrayList<AdditionalField>(split.length);
        for (String additionalField : split) {
            AdditionalField field = AdditionalField.of(additionalField);
            result.add(field);
        }
        return result;
    }

    public static AdditionalField of(String additionalField) {
        String[] keyValue = additionalField.split("=");
        if (keyValue.length != 2) {
            throw new IllegalArgumentException("Could not parse " + additionalField);
        }
        return new AdditionalField(keyValue[0].trim(), keyValue[1].trim());
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

