/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.treeinsert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import opennlp.tools.parser.AbstractContextGenerator;
import opennlp.tools.parser.Cons;
import opennlp.tools.parser.Parse;

public class AttachContextGenerator
extends AbstractContextGenerator {
    public AttachContextGenerator(Set<String> punctSet) {
        this.punctSet = punctSet;
    }

    public String[] getContext(Object o) {
        Object[] parts = (Object[])o;
        return this.getContext((Parse[])parts[0], (Integer)parts[1], (List)parts[2], (Integer)parts[3]);
    }

    private boolean containsPunct(Collection<Parse> puncts, String punct) {
        if (puncts != null) {
            for (Parse p : puncts) {
                if (!p.getType().equals(punct)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getContext(Parse[] constituents, int index, List<Parse> rightFrontier, int rfi) {
        ArrayList<String> features = new ArrayList<String>(100);
        Parse fn = rightFrontier.get(rfi);
        Parse fp = null;
        if (rfi + 1 < rightFrontier.size()) {
            fp = rightFrontier.get(rfi + 1);
        }
        Parse p_1 = null;
        if (rightFrontier.size() > 0) {
            p_1 = rightFrontier.get(0);
        }
        Parse p0 = constituents[index];
        Parse p1 = null;
        if (index + 1 < constituents.length) {
            p1 = constituents[index + 1];
        }
        Collection<Parse> punct_1fs = fn.getPreviousPunctuationSet();
        Collection<Parse> punct_1s = p0.getPreviousPunctuationSet();
        Collection<Parse> punct1s = p0.getNextPunctuationSet();
        String consfp = this.cons(fp, -3);
        String consf = this.cons(fn, -2);
        String consp_1 = this.cons(p_1, -1);
        String consp0 = this.cons(p0, 0);
        String consp1 = this.cons(p1, 1);
        String consbofp = this.consbo(fp, -3);
        String consbof = this.consbo(fn, -2);
        String consbop_1 = this.consbo(p_1, -1);
        String consbop0 = this.consbo(p0, 0);
        String consbop1 = this.consbo(p1, 1);
        Cons cfp = new Cons(consfp, consbofp, -3, true);
        Cons cf = new Cons(consf, consbof, -2, true);
        Cons c_1 = new Cons(consp_1, consbop_1, -1, true);
        Cons c0 = new Cons(consp0, consbop0, 0, true);
        Cons c1 = new Cons(consp1, consbop1, 1, true);
        features.add("default");
        features.add(consfp);
        features.add(consbofp);
        features.add(consf);
        features.add(consbof);
        features.add(consp_1);
        features.add(consbop_1);
        features.add(consp0);
        features.add(consbop0);
        features.add(consp1);
        features.add(consbop1);
        String prod = this.production(fn, false);
        features.add("pn=" + prod);
        features.add("pd=" + prod + "," + p0.getType());
        features.add("ps=" + fn.getType() + "->" + fn.getType() + "," + p0.getType());
        if (punct_1s != null) {
            StringBuilder punctBuf = new StringBuilder(5);
            for (Parse punct : punct_1s) {
                punctBuf.append(punct.getType()).append(",");
            }
        }
        this.cons2(features, cfp, c0, punct_1s, true);
        this.cons2(features, cf, c0, punct_1s, true);
        this.cons2(features, c_1, c0, punct_1s, true);
        this.cons2(features, c0, c1, punct1s, true);
        this.cons3(features, cf, c_1, c0, null, punct_1s, true, true, true);
        this.cons3(features, cf, c0, c1, punct_1s, punct1s, true, true, true);
        this.cons3(features, cfp, cf, c0, null, punct_1s, true, true, true);
        int headDistance = p0.getHeadIndex() - fn.getHeadIndex();
        features.add("hd=" + headDistance);
        features.add("nd=" + rfi);
        features.add("nd=" + p0.getType() + "." + rfi);
        features.add("hd=" + p0.getType() + "." + headDistance);
        if (this.containsPunct(punct_1s, "''") && this.containsPunct(punct_1fs, "``")) {
            features.add("quotematch");
        }
        return features.toArray(new String[features.size()]);
    }
}

