/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.common;

import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.dependency.CoNll.PosTagCompiler;
import com.hankcs.hanlp.corpus.synonym.Synonym;
import com.hankcs.hanlp.corpus.synonym.SynonymHelper;
import com.hankcs.hanlp.dictionary.CoreBiGramTableDictionary;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;

public class CommonSynonymDictionary {
    DoubleArrayTrie<SynonymItem> trie;
    private long maxSynonymItemIdDistance;

    private CommonSynonymDictionary() {
    }

    public static CommonSynonymDictionary create(InputStream inputStream) {
        CommonSynonymDictionary dictionary = new CommonSynonymDictionary();
        if (dictionary.load(inputStream)) {
            return dictionary;
        }
        return null;
    }

    public boolean load(InputStream inputStream) {
        this.trie = new DoubleArrayTrie();
        TreeMap<String, SynonymItem> treeMap = new TreeMap<String, SynonymItem>();
        String line = null;
        try {
            int resultCode;
            BufferedReader bw = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            ArrayList<Synonym> synonymList = null;
            while ((line = bw.readLine()) != null) {
                String[] args = line.split(" ");
                synonymList = Synonym.create(args);
                char type = args[0].charAt(args[0].length() - 1);
                for (Synonym synonym : synonymList) {
                    treeMap.put(synonym.realWord, new SynonymItem(synonym, synonymList, type));
                }
            }
            bw.close();
            if (synonymList != null && synonymList.size() > 0) {
                this.maxSynonymItemIdDistance = synonymList.get((int)(synonymList.size() - 1)).id - SynonymHelper.convertString2IdWithIndex("Aa01A01", 0) + 1L;
            }
            if ((resultCode = this.trie.build(treeMap)) != 0) {
                Predefine.logger.warning("\u6784\u5efa" + inputStream + "\u5931\u8d25\uff0c\u9519\u8bef\u7801" + resultCode);
                return false;
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + inputStream + "\u5931\u8d25\uff0c\u53ef\u80fd\u7531\u884c" + line + "\u9020\u6210");
            return false;
        }
        return true;
    }

    public SynonymItem get(String key) {
        return this.trie.get(key);
    }

    public long getMaxSynonymItemIdDistance() {
        return this.maxSynonymItemIdDistance;
    }

    public long distance(String a, String b) {
        SynonymItem itemA = this.get(a);
        if (itemA == null) {
            return 0x2AAAAAAAAAAAAAAAL;
        }
        SynonymItem itemB = this.get(b);
        if (itemB == null) {
            return 0x2AAAAAAAAAAAAAAAL;
        }
        return itemA.distance(itemB);
    }

    public String rewriteQuickly(String text) {
        assert (text != null);
        StringBuilder sbOut = new StringBuilder((int)((double)text.length() * 1.2));
        String preWord = "\u59cb##\u59cb";
        for (int i = 0; i < text.length(); ++i) {
            int state = 1;
            state = this.trie.transition(text.charAt(i), state);
            if (state > 0) {
                int start = i;
                int end = -1;
                SynonymItem value = null;
                for (int to = i + 1; to < text.length() && (state = this.trie.transition(text.charAt(to), state)) >= 0; ++to) {
                    SynonymItem output = this.trie.output(state);
                    if (output == null) continue;
                    value = output;
                    end = to + 1;
                }
                if (value != null) {
                    Synonym synonym = value.randomSynonym(Synonym.Type.EQUAL, preWord);
                    if (synonym != null) {
                        sbOut.append(synonym.realWord);
                        preWord = synonym.realWord;
                    } else {
                        preWord = text.substring(start, end);
                        sbOut.append(preWord);
                    }
                    i = end - 1;
                    continue;
                }
                preWord = String.valueOf(text.charAt(i));
                sbOut.append(text.charAt(i));
                continue;
            }
            preWord = String.valueOf(text.charAt(i));
            sbOut.append(text.charAt(i));
        }
        return sbOut.toString();
    }

    public String rewrite(String text) {
        List<Term> termList = StandardTokenizer.segment(text.toCharArray());
        StringBuilder sbOut = new StringBuilder((int)((double)text.length() * 1.2));
        String preWord = "\u59cb##\u59cb";
        for (Term term : termList) {
            Synonym synonym;
            SynonymItem synonymItem = this.get(term.word);
            if (synonymItem != null && (synonym = synonymItem.randomSynonym(Synonym.Type.EQUAL, preWord)) != null) {
                sbOut.append(synonym.realWord);
            } else {
                sbOut.append(term.word);
            }
            preWord = PosTagCompiler.compile(term.nature.toString(), term.word);
        }
        return sbOut.toString();
    }

    public static class SynonymItem {
        public Synonym entry;
        public List<Synonym> synonymList;
        public Synonym.Type type;

        public SynonymItem(Synonym entry, List<Synonym> synonymList, Synonym.Type type) {
            this.entry = entry;
            this.synonymList = synonymList;
            this.type = type;
        }

        public SynonymItem(Synonym entry, List<Synonym> synonymList, char type) {
            this.entry = entry;
            this.synonymList = synonymList;
            switch (type) {
                case '=': {
                    this.type = Synonym.Type.EQUAL;
                    break;
                }
                case '#': {
                    this.type = Synonym.Type.LIKE;
                    break;
                }
                default: {
                    this.type = Synonym.Type.SINGLE;
                }
            }
        }

        public Synonym randomSynonym(Synonym.Type type, String preWord) {
            ArrayList<Synonym> synonymArrayList = new ArrayList<Synonym>(this.synonymList);
            ListIterator<Synonym> listIterator = synonymArrayList.listIterator();
            if (type != null) {
                while (listIterator.hasNext()) {
                    Synonym synonym = listIterator.next();
                    if (synonym.type == type && (preWord == null || CoreBiGramTableDictionary.getBiFrequency(preWord, synonym.realWord) != 0)) continue;
                    listIterator.remove();
                }
            }
            if (synonymArrayList.size() == 0) {
                return null;
            }
            return synonymArrayList.get((int)(System.currentTimeMillis() % (long)synonymArrayList.size()));
        }

        public Synonym randomSynonym() {
            return this.randomSynonym(null, null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.entry);
            sb.append(' ');
            sb.append((Object)this.type);
            sb.append(' ');
            sb.append(this.synonymList);
            return sb.toString();
        }

        public long distance(SynonymItem other) {
            return this.entry.distance(other.entry);
        }

        public static SynonymItem createUndefined(String word) {
            SynonymItem item = new SynonymItem(new Synonym(word, (long)(word.hashCode() * 1000000) + 0x2AAAAAAAAAAAAAAAL), null, Synonym.Type.UNDEFINED);
            return item;
        }
    }
}

