﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/datazone/DataZone_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DataZone {
namespace Model {

/**
 * <p>The summary of the metadata form.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/MetadataFormSummary">AWS
 * API Reference</a></p>
 */
class MetadataFormSummary {
 public:
  AWS_DATAZONE_API MetadataFormSummary() = default;
  AWS_DATAZONE_API MetadataFormSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API MetadataFormSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The form name of the metadata form.</p>
   */
  inline const Aws::String& GetFormName() const { return m_formName; }
  inline bool FormNameHasBeenSet() const { return m_formNameHasBeenSet; }
  template <typename FormNameT = Aws::String>
  void SetFormName(FormNameT&& value) {
    m_formNameHasBeenSet = true;
    m_formName = std::forward<FormNameT>(value);
  }
  template <typename FormNameT = Aws::String>
  MetadataFormSummary& WithFormName(FormNameT&& value) {
    SetFormName(std::forward<FormNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type name of the metadata form.</p>
   */
  inline const Aws::String& GetTypeName() const { return m_typeName; }
  inline bool TypeNameHasBeenSet() const { return m_typeNameHasBeenSet; }
  template <typename TypeNameT = Aws::String>
  void SetTypeName(TypeNameT&& value) {
    m_typeNameHasBeenSet = true;
    m_typeName = std::forward<TypeNameT>(value);
  }
  template <typename TypeNameT = Aws::String>
  MetadataFormSummary& WithTypeName(TypeNameT&& value) {
    SetTypeName(std::forward<TypeNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type revision of the metadata form.</p>
   */
  inline const Aws::String& GetTypeRevision() const { return m_typeRevision; }
  inline bool TypeRevisionHasBeenSet() const { return m_typeRevisionHasBeenSet; }
  template <typename TypeRevisionT = Aws::String>
  void SetTypeRevision(TypeRevisionT&& value) {
    m_typeRevisionHasBeenSet = true;
    m_typeRevision = std::forward<TypeRevisionT>(value);
  }
  template <typename TypeRevisionT = Aws::String>
  MetadataFormSummary& WithTypeRevision(TypeRevisionT&& value) {
    SetTypeRevision(std::forward<TypeRevisionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_formName;

  Aws::String m_typeName;

  Aws::String m_typeRevision;
  bool m_formNameHasBeenSet = false;
  bool m_typeNameHasBeenSet = false;
  bool m_typeRevisionHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataZone
}  // namespace Aws
