from _typeshed import Incomplete
from _typeshed.wsgi import WSGIEnvironment
from collections.abc import ItemsView, Iterator, KeysView, MutableMapping, ValuesView
from datetime import date, datetime, timedelta
from typing import TypeVar, overload
from typing_extensions import Literal

from webob.descriptors import _AsymmetricProperty

_T = TypeVar("_T")

class RequestCookies(MutableMapping[str, str]):
    def __init__(self, environ: WSGIEnvironment) -> None: ...
    def __setitem__(self, name: str, value: str) -> None: ...
    def __getitem__(self, name: str) -> str: ...
    @overload
    def get(self, name: str, default: None = None) -> str | None: ...
    @overload
    def get(self, name: str, default: str | _T) -> str | _T: ...
    def __delitem__(self, name: str) -> None: ...
    def keys(self) -> KeysView[str]: ...
    def values(self) -> ValuesView[str]: ...
    def items(self) -> ItemsView[str, str]: ...
    def __contains__(self, name: object) -> bool: ...
    def __iter__(self) -> Iterator[str]: ...
    def __len__(self) -> int: ...
    def clear(self) -> None: ...

class Cookie(dict[str, Morsel]):
    def __init__(self, input: str | None = None) -> None: ...
    def load(self, data: str) -> None: ...
    def add(self, key: str | bytes, val: str | bytes) -> Morsel: ...
    def __setitem__(self, key: str | bytes, val: str | bytes) -> Morsel: ...  # type:ignore[override]
    def serialize(self, full: bool = True) -> str: ...
    def values(self) -> list[Morsel]: ...  # type:ignore[override]
    def __str__(self, full: bool = True) -> str: ...

class Morsel(dict[bytes, bytes | bool | None]):
    name: bytes
    value: bytes
    def __init__(self, name: str | bytes, value: str | bytes) -> None: ...
    @property
    def path(self) -> bytes | None: ...
    @path.setter
    def path(self, v: bytes | None) -> None: ...
    @property
    def domain(self) -> bytes | None: ...
    @domain.setter
    def domain(self, v: bytes | None) -> None: ...
    @property
    def comment(self) -> bytes | None: ...
    @comment.setter
    def comment(self, v: bytes | None) -> None: ...
    expires: _AsymmetricProperty[bytes | None, datetime | date | timedelta | int | str | bytes | None]
    max_age: _AsymmetricProperty[bytes | None, timedelta | int | str | bytes]
    @property
    def httponly(self) -> bool | None: ...
    @httponly.setter
    def httponly(self, v: bool) -> None: ...
    @property
    def secure(self) -> bool | None: ...
    @secure.setter
    def secure(self, v: bool) -> None: ...
    samesite: _AsymmetricProperty[bytes | None, Literal["strict", "lax", "none"] | None]
    def serialize(self, full: bool = True) -> str: ...
    def __str__(self, full: bool = True) -> str: ...

def make_cookie(
    name: str | bytes,
    value: str | bytes | None,
    max_age: int | timedelta | None = None,
    path: str = "/",
    domain: str | None = None,
    secure: bool = False,
    httponly: bool = False,
    comment: str | None = None,
    samesite: Literal["strict", "lax", "none"] | None = None,
) -> str: ...

class JSONSerializer:
    def dumps(self, appstruct): ...
    def loads(self, bstruct): ...

class Base64Serializer:
    serializer: Incomplete
    def __init__(self, serializer: Incomplete | None = None) -> None: ...
    def dumps(self, appstruct): ...
    def loads(self, bstruct): ...

class SignedSerializer:
    salt: Incomplete
    secret: Incomplete
    hashalg: Incomplete
    salted_secret: Incomplete
    digestmod: Incomplete
    digest_size: Incomplete
    serializer: Incomplete
    def __init__(self, secret, salt, hashalg: str = "sha512", serializer: Incomplete | None = None) -> None: ...
    def dumps(self, appstruct): ...
    def loads(self, bstruct): ...

class CookieProfile:
    cookie_name: Incomplete
    secure: Incomplete
    max_age: Incomplete
    httponly: Incomplete
    samesite: Incomplete
    path: Incomplete
    domains: Incomplete
    serializer: Incomplete
    request: Incomplete
    def __init__(
        self,
        cookie_name,
        secure: bool = False,
        max_age: Incomplete | None = None,
        httponly: Incomplete | None = None,
        samesite: Incomplete | None = None,
        path: str = "/",
        domains: Incomplete | None = None,
        serializer: Incomplete | None = None,
    ) -> None: ...
    def __call__(self, request): ...
    def bind(self, request): ...
    def get_value(self): ...
    def set_cookies(self, response, value, domains=..., max_age=..., path=..., secure=..., httponly=..., samesite=...): ...
    def get_headers(self, value, domains=..., max_age=..., path=..., secure=..., httponly=..., samesite=...): ...

class SignedCookieProfile(CookieProfile):
    secret: Incomplete
    salt: Incomplete
    hashalg: Incomplete
    original_serializer: Incomplete
    def __init__(
        self,
        secret,
        salt,
        cookie_name,
        secure: bool = False,
        max_age: Incomplete | None = None,
        httponly: bool = False,
        samesite: Incomplete | None = None,
        path: str = "/",
        domains: Incomplete | None = None,
        hashalg: str = "sha512",
        serializer: Incomplete | None = None,
    ) -> None: ...
    def bind(self, request): ...
