/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLHintUtils;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.data.type.OpenSearchTextType;
import org.opensearch.sql.opensearch.planner.rules.OpenSearchIndexRules;
import org.opensearch.sql.opensearch.request.AggregateAnalyzer;
import org.opensearch.sql.opensearch.request.PredicateAnalyzer;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.scan.AbstractCalciteIndexScan;
import org.opensearch.sql.opensearch.storage.scan.context.AbstractAction;
import org.opensearch.sql.opensearch.storage.scan.context.AggPushDownAction;
import org.opensearch.sql.opensearch.storage.scan.context.FilterDigest;
import org.opensearch.sql.opensearch.storage.scan.context.LimitDigest;
import org.opensearch.sql.opensearch.storage.scan.context.OSRequestBuilderAction;
import org.opensearch.sql.opensearch.storage.scan.context.ProjectDigest;
import org.opensearch.sql.opensearch.storage.scan.context.PushDownContext;
import org.opensearch.sql.opensearch.storage.scan.context.PushDownType;
import org.opensearch.sql.opensearch.storage.scan.context.RareTopDigest;
import org.opensearch.sql.utils.Utils;

public class CalciteLogicalIndexScan
extends AbstractCalciteIndexScan {
    private static final Logger LOG = LogManager.getLogger(CalciteLogicalIndexScan.class);

    public CalciteLogicalIndexScan(RelOptCluster cluster, RelOptTable table, OpenSearchIndex osIndex) {
        this(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), (List<RelHint>)ImmutableList.of(), table, osIndex, table.getRowType(), new PushDownContext(osIndex));
    }

    protected CalciteLogicalIndexScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, OpenSearchIndex osIndex, RelDataType schema, PushDownContext pushDownContext) {
        super(cluster, traitSet, hints, table, osIndex, schema, pushDownContext);
    }

    @Override
    protected AbstractCalciteIndexScan buildScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, OpenSearchIndex osIndex, RelDataType schema, PushDownContext pushDownContext) {
        return new CalciteLogicalIndexScan(cluster, traitSet, hints, table, osIndex, schema, pushDownContext);
    }

    @Override
    public CalciteLogicalIndexScan copy() {
        return new CalciteLogicalIndexScan(this.getCluster(), this.traitSet, (List<RelHint>)this.hints, this.table, this.osIndex, this.schema, this.pushDownContext.clone());
    }

    public CalciteLogicalIndexScan copyWithNewSchema(RelDataType schema) {
        return new CalciteLogicalIndexScan(this.getCluster(), this.traitSet, (List<RelHint>)this.hints, this.table, this.osIndex, schema, this.pushDownContext.clone());
    }

    public CalciteLogicalIndexScan copyWithNewTraitSet(RelTraitSet traitSet) {
        return new CalciteLogicalIndexScan(this.getCluster(), traitSet, (List<RelHint>)this.hints, this.table, this.osIndex, this.schema, this.pushDownContext.clone());
    }

    public void register(RelOptPlanner planner) {
        super.register(planner);
        for (RelOptRule rule : OpenSearchIndexRules.OPEN_SEARCH_NON_PUSHDOWN_RULES) {
            planner.addRule(rule);
        }
        if (((Boolean)this.osIndex.getSettings().getSettingValue(Settings.Key.CALCITE_PUSHDOWN_ENABLED)).booleanValue()) {
            for (RelOptRule rule : OpenSearchIndexRules.OPEN_SEARCH_PUSHDOWN_RULES) {
                planner.addRule(rule);
            }
        }
    }

    public AbstractRelNode pushDownFilter(Filter filter) {
        try {
            RelDataType rowType = this.getRowType();
            List<String> schema = this.buildSchema();
            Map<String, ExprType> fieldTypes = this.osIndex.getAllFieldTypes();
            PredicateAnalyzer.QueryExpression queryExpression = PredicateAnalyzer.analyzeExpression(filter.getCondition(), schema, fieldTypes, rowType, this.getCluster());
            CalciteLogicalIndexScan newScan = this.copy();
            newScan.pushDownContext.add(queryExpression.getScriptCount() > 0 ? PushDownType.SCRIPT : PushDownType.FILTER, new FilterDigest(queryExpression.getScriptCount(), queryExpression.isPartial() ? CalciteLogicalIndexScan.constructCondition(queryExpression.getAnalyzedNodes(), this.getCluster().getRexBuilder()) : filter.getCondition()), requestBuilder -> requestBuilder.pushDownFilterForCalcite(queryExpression.builder()));
            if (queryExpression.isPartial()) {
                List<RexNode> conditions = queryExpression.getUnAnalyzableNodes();
                RexNode newCondition = CalciteLogicalIndexScan.constructCondition(conditions, this.getCluster().getRexBuilder());
                return filter.copy(filter.getTraitSet(), (RelNode)newScan, newCondition);
            }
            return newScan;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the filter condition.", (Throwable)e);
            }
            return null;
        }
    }

    private List<String> buildSchema() {
        ArrayList<String> schema = new ArrayList<String>(this.getRowType().getFieldNames());
        List<String> nestedPaths = schema.stream().map(field -> Utils.resolveNestedPath((String)field, this.osIndex.getAllFieldTypes())).filter(Objects::nonNull).distinct().toList();
        schema.addAll(nestedPaths);
        return schema;
    }

    private static RexNode constructCondition(List<RexNode> conditions, RexBuilder rexBuilder) {
        return conditions.size() > 1 ? rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, conditions) : conditions.get(0);
    }

    public CalciteLogicalIndexScan pushDownCollapse(Project finalOutput, String fieldName) {
        ExprType fieldType = this.osIndex.getFieldTypes().get(fieldName);
        if (fieldType == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the dedup '{}' due to it is not a index field", (Object)fieldName);
            }
            return null;
        }
        ExprType originalExprType = fieldType.getOriginalExprType();
        String originalFieldName = originalExprType.getOriginalPath().orElse(fieldName);
        if (!(ExprCoreType.numberTypes().contains(originalExprType) || originalExprType.legacyTypeName().equals("KEYWORD") || originalExprType.legacyTypeName().equals("TEXT"))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the dedup '{}' due to only keyword and number type are accepted, but its type is {}", (Object)originalFieldName, (Object)originalExprType.legacyTypeName());
            }
            return null;
        }
        String field = OpenSearchTextType.toKeywordSubField(originalFieldName, fieldType);
        if (field == null) {
            LOG.debug("Cannot pushdown the dedup due to no keyword subfield for {}.", (Object)fieldName);
            return null;
        }
        CalciteLogicalIndexScan newScan = this.copyWithNewSchema(finalOutput.getRowType());
        newScan.pushDownContext.add(PushDownType.AGGREGATION, fieldName, requestBuilder -> requestBuilder.pushDownCollapse(field));
        return newScan;
    }

    public CalciteLogicalIndexScan pushDownProject(List<Integer> selectedColumns) {
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        List fieldList = this.getRowType().getFieldList();
        for (int project : selectedColumns) {
            builder.add((RelDataTypeField)fieldList.get(project));
        }
        RelDataType newSchema = builder.build();
        if (this.getPushDownContext().containsDigest(newSchema.getFieldNames())) {
            return null;
        }
        RelTraitSet traitSetWithReIndexedCollations = this.reIndexCollations(selectedColumns);
        CalciteLogicalIndexScan newScan = new CalciteLogicalIndexScan(this.getCluster(), traitSetWithReIndexedCollations, (List<RelHint>)this.hints, this.table, this.osIndex, newSchema, this.pushDownContext.clone());
        AbstractAction<AggPushDownAction> action = this.pushDownContext.isAggregatePushed() ? aggAction -> {} : requestBuilder -> requestBuilder.pushDownProjectStream(newSchema.getFieldNames().stream());
        newScan.pushDownContext.add(PushDownType.PROJECT, new ProjectDigest(newSchema.getFieldNames(), selectedColumns), action);
        return newScan;
    }

    private RelTraitSet reIndexCollations(List<Integer> selectedColumns) {
        RelTraitSet newTraitSet;
        RelCollation relCollation = this.getTraitSet().getCollation();
        if (!Objects.isNull(relCollation) && !relCollation.getFieldCollations().isEmpty()) {
            List newCollations = relCollation.getFieldCollations().stream().filter(collation -> selectedColumns.contains(collation.getFieldIndex())).map(collation -> collation.withFieldIndex(selectedColumns.indexOf(collation.getFieldIndex()))).collect(Collectors.toList());
            newTraitSet = this.getTraitSet().plus((RelTrait)RelCollations.of(newCollations));
        } else {
            newTraitSet = this.getTraitSet();
        }
        return newTraitSet;
    }

    public CalciteLogicalIndexScan pushDownSortAggregateMeasure(Sort sort) {
        try {
            if (!this.pushDownContext.isAggregatePushed()) {
                return null;
            }
            List aggregationBuilders = (List)this.pushDownContext.getAggPushDownAction().getBuilderAndParser().getLeft();
            if (aggregationBuilders.size() != 1) {
                return null;
            }
            if (!(aggregationBuilders.getFirst() instanceof CompositeAggregationBuilder)) {
                return null;
            }
            List<String> collationNames = this.getCollationNames(sort.getCollation().getFieldCollations());
            if (!this.isAnyCollationNameInAggregators(collationNames)) {
                return null;
            }
            CalciteLogicalIndexScan newScan = this.copyWithNewTraitSet(sort.getTraitSet());
            newScan.pushDownContext.getAggPushDownAction().rePushDownSortAggMeasure(sort.getCollation().getFieldCollations(), this.rowType.getFieldNames());
            OSRequestBuilderAction action = requestAction -> requestAction.resetRequestTotal();
            List digest = sort.getCollation().getFieldCollations();
            newScan.pushDownContext.add(PushDownType.SORT_AGG_METRICS, digest, action);
            return newScan;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the sort aggregate {}", (Object)sort, (Object)e);
            }
            return null;
        }
    }

    public CalciteLogicalIndexScan pushDownRareTop(Project project, RareTopDigest digest) {
        try {
            CalciteLogicalIndexScan newScan = this.copyWithNewSchema(project.getRowType());
            newScan.pushDownContext.getAggPushDownAction().rePushDownRareTop(digest);
            OSRequestBuilderAction action = requestAction -> requestAction.resetRequestTotal();
            newScan.pushDownContext.add(PushDownType.RARE_TOP, digest, action);
            return newScan;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown {}", (Object)digest, (Object)e);
            }
            return null;
        }
    }

    public AbstractRelNode pushDownAggregate(Aggregate aggregate, @Nullable Project project) {
        try {
            CalciteLogicalIndexScan newScan = new CalciteLogicalIndexScan(this.getCluster(), this.traitSet, (List<RelHint>)this.hints, this.table, this.osIndex, aggregate.getRowType(), this.pushDownContext.cloneForAggregate(aggregate, project));
            List<String> schema = this.buildSchema();
            Map<String, ExprType> fieldTypes = this.osIndex.getAllFieldTypes().entrySet().stream().filter(entry -> schema.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List outputFields = aggregate.getRowType().getFieldNames();
            List<String> bucketNames = outputFields.subList(0, aggregate.getGroupSet().cardinality());
            if (bucketNames.stream().map(b -> (ExprType)fieldTypes.get(b)).filter(Objects::nonNull).anyMatch(expr -> expr.getOriginalType() == ExprCoreType.ARRAY)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cannot pushdown the aggregate due to bucket contains array (nested) type");
                }
                return null;
            }
            int queryBucketSize = this.osIndex.getQueryBucketSize();
            boolean bucketNullable = !PPLHintUtils.ignoreNullBucket((Aggregate)aggregate);
            AggregateAnalyzer.AggregateBuilderHelper helper = new AggregateAnalyzer.AggregateBuilderHelper(this.getRowType(), fieldTypes, this.getCluster(), bucketNullable, queryBucketSize);
            Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> builderAndParser = AggregateAnalyzer.analyze(aggregate, project, outputFields, helper);
            Map<String, OpenSearchDataType> extendedTypeMapping = aggregate.getRowType().getFieldList().stream().collect(Collectors.toMap(RelDataTypeField::getName, field -> OpenSearchDataType.of(OpenSearchTypeFactory.convertRelDataTypeToExprType((RelDataType)field.getType()))));
            AggPushDownAction action = new AggPushDownAction(builderAndParser, extendedTypeMapping, bucketNames);
            newScan.pushDownContext.add(PushDownType.AGGREGATION, aggregate, action);
            return newScan;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the aggregate {}", (Object)aggregate, (Object)e);
            }
            return null;
        }
    }

    public AbstractRelNode pushDownLimit(LogicalSort sort, Integer limit, Integer offset) {
        try {
            if (this.pushDownContext.isAggregatePushed()) {
                boolean canUpdate;
                int totalSize = limit + offset;
                boolean canReduceEstimatedRowsCount = !this.pushDownContext.isLimitPushed() || this.pushDownContext.getQueue().reversed().stream().takeWhile(op -> op.type() != PushDownType.AGGREGATION).filter(op -> op.type() == PushDownType.LIMIT).findFirst().map(op -> (LimitDigest)op.digest()).map(d -> totalSize < d.offset() + d.limit()).orElse(true) != false;
                boolean bl = canUpdate = canReduceEstimatedRowsCount || this.pushDownContext.getAggPushDownAction().pushDownLimitIntoBucketSize(totalSize);
                if (!canUpdate && offset > 0) {
                    return null;
                }
                CalciteLogicalIndexScan newScan = this.copyWithNewSchema(this.getRowType());
                if (canUpdate) {
                    newScan.pushDownContext.getAggPushDownAction().pushDownLimitIntoBucketSize(limit + offset);
                }
                AbstractAction<AggPushDownAction> action = this.pushDownContext.getAggPushDownAction().isCompositeAggregation() ? requestBuilder -> requestBuilder.pushDownLimitToRequestTotal(limit, offset) : aggAction -> {};
                newScan.pushDownContext.add(PushDownType.LIMIT, new LimitDigest(limit, offset), action);
                return offset > 0 ? sort.copy(sort.getTraitSet(), List.of(newScan)) : newScan;
            }
            LimitDigest digest = new LimitDigest(limit, offset);
            if (this.pushDownContext.containsDigestOnTop(digest)) {
                return null;
            }
            CalciteLogicalIndexScan newScan = this.copyWithNewSchema(this.getRowType());
            newScan.pushDownContext.add(PushDownType.LIMIT, digest, requestBuilder -> requestBuilder.pushDownLimit(limit, offset));
            return newScan;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown limit {} with offset {}", (Object)limit, (Object)offset, (Object)e);
            }
            return null;
        }
    }
}

