/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.model.DataSource;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.datasources.auth.AuthenticationType;
import org.opensearch.sql.datasources.utils.DatasourceValidationUtils;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.client.PrometheusClientImpl;
import org.opensearch.sql.prometheus.storage.PrometheusStorageEngine;
import org.opensearch.sql.prometheus.utils.PrometheusClientUtils;
import org.opensearch.sql.storage.DataSourceFactory;
import org.opensearch.sql.storage.StorageEngine;

public class PrometheusStorageFactory
implements DataSourceFactory {
    public static final String URI = "prometheus.uri";
    public static final String AUTH_TYPE = "prometheus.auth.type";
    public static final String USERNAME = "prometheus.auth.username";
    public static final String PASSWORD = "prometheus.auth.password";
    public static final String REGION = "prometheus.auth.region";
    public static final String ACCESS_KEY = "prometheus.auth.access_key";
    public static final String SECRET_KEY = "prometheus.auth.secret_key";
    private final Settings settings;

    public DataSourceType getDataSourceType() {
        return DataSourceType.PROMETHEUS;
    }

    public DataSource createDataSource(DataSourceMetadata metadata) {
        return new DataSource(metadata.getName(), DataSourceType.PROMETHEUS, this.getStorageEngine(metadata.getProperties()));
    }

    StorageEngine getStorageEngine(Map<String, String> requiredConfig) {
        PrometheusClientImpl prometheusClient;
        try {
            this.validateDataSourceConfigProperties(requiredConfig);
            prometheusClient = new PrometheusClientImpl(PrometheusClientUtils.getHttpClient(requiredConfig, (Settings)this.settings), new URI(requiredConfig.get(URI)));
        }
        catch (URISyntaxException | UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Invalid URI in prometheus properties: %s", e.getMessage()));
        }
        return new PrometheusStorageEngine((PrometheusClient)prometheusClient);
    }

    private void validateDataSourceConfigProperties(Map<String, String> dataSourceMetadataConfig) throws URISyntaxException, UnknownHostException {
        if (dataSourceMetadataConfig.get(AUTH_TYPE) != null) {
            AuthenticationType authenticationType = AuthenticationType.get((String)dataSourceMetadataConfig.get(AUTH_TYPE));
            if (AuthenticationType.BASICAUTH.equals((Object)authenticationType)) {
                DatasourceValidationUtils.validateLengthAndRequiredFields(dataSourceMetadataConfig, Set.of(URI, USERNAME, PASSWORD));
            } else if (AuthenticationType.AWSSIGV4AUTH.equals((Object)authenticationType)) {
                DatasourceValidationUtils.validateLengthAndRequiredFields(dataSourceMetadataConfig, Set.of(URI, ACCESS_KEY, SECRET_KEY, REGION));
            }
        } else {
            DatasourceValidationUtils.validateLengthAndRequiredFields(dataSourceMetadataConfig, Set.of(URI));
        }
        DatasourceValidationUtils.validateHost((String)dataSourceMetadataConfig.get(URI), (List)((List)this.settings.getSettingValue(Settings.Key.DATASOURCES_URI_HOSTS_DENY_LIST)));
    }

    @Generated
    public PrometheusStorageFactory(Settings settings) {
        this.settings = settings;
    }
}

