<?php

require_once 'root.class.php';

//******************************************************************************

class CM_Image extends CM_Root
{
	
	//--------------------------------------------------------------------------
	
	function CM_Image()
	{
		// $key, $data_type, $default, $required, $size
		$this->initVar('c_image_id', XOBJ_DTYPE_INT);
		$this->initVar('filename', XOBJ_DTYPE_TXTBOX);
		$this->initVar('target', XOBJ_DTYPE_INT);
		$this->initVar('target_id', XOBJ_DTYPE_INT);
		$this->initVar('uid', XOBJ_DTYPE_INT);
	}
	
	//--------------------------------------------------------------------------
	
	function &getInfo($thumb_id=2)
	{
		$id = $this->getVar('c_image_id');
		$filename = $this->getVar('filename');
		
		$ret = array(
			'c_image_id' => $id,
			'filename' => $filename,
			'url' => _CM_IMAGE_LOAD_URL.'?f='.$filename,
			'url_src' => _CM_IMAGE_LOAD_URL.'?f='.$filename.'&t='.$thumb_id,
			'url_del' => _CM_URL_FILE.'&image_id='.$id,
		);
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
}

//******************************************************************************

class CM_ImageHandler extends CM_RootHandler
{
	var $upload_dir = NULL;
	var $dir_exists = true;
	//--------------------------------------------------------------------------
	
	function CM_ImageHandler()
	{
		$this->CM_RootHandler();
		$this->obj_class = "CM_Image";
		$this->table_name = "c_image";
		$this->primary_key = "c_image_id";
		
		if(isset($this->module_config['file_upload_path'])){
			$this->upload_dir = $this->module_config['file_upload_path'];
			$this->dir_exists = is_dir($this->upload_dir) ? true : false;
		}
		else{
			$this->dir_exists = false;
		}
	}
	
	//--------------------------------------------------------------------------
	
	function &getInstance()
	{
		static $instance = NULL;
		if(is_null($instance)){
			$instance = new CM_ImageHandler();
		}
		return $instance;
	}
	
	//--------------------------------------------------------------------------
	
	function &getList($target, $target_id, $thumb_id=_CM_IMAGE_SIZE_M)
	{
		$ret = array();
		if(!$this->dir_exists){
			return $ret;
		}
		
		$criteria = new CriteriaCompo(new Criteria('target', $target));
		$criteria->add(new Criteria('target_id', $target_id));
		if(!($obj_list =& $this->getObjects($criteria))){
			return $ret;
		}
		
		foreach($obj_list as $obj){
			if(@file_exists($this->upload_dir.'/'.$obj->getVar('filename'))){
				$ret[] =& $obj->getInfo($thumb_id);
			}
		}
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
	function &getListByIds($target, $target_ids, $thumb_id=_CM_IMAGE_SIZE_M)
	{
		$ret = array();
		if(!$this->dir_exists || !is_array($target_ids)){
			return $ret;
		}
		
		$criteria = new CriteriaCompo(new Criteria('target', $target));
		$criteria->add(new Criteria('target_id', '('.implode(',', $target_ids).')', 'IN'));
		if(!($obj_list =& $this->getObjects($criteria))){
			return $ret;
		}
		
		foreach($obj_list as $obj){
			if(@file_exists($this->upload_dir.'/'.$obj->getVar('filename'))){
				$ret[$obj->getVar('target_id')][] =& $obj->getInfo($thumb_id);
			}
		}
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
	// ꎞ摜̃Abv[h
	function uploadImageTemp($name)
	{
		if(!isset($_FILES[$name]) || !$this->dir_exists){
			return false;
		}
		$thumb_id = _CM_IMAGE_SIZE_M;
		
		require_once APP_USERLIB_DIR.'/image_uploader.php';
		
		$file_count = count($_FILES[$name]['name']);
		$mime = "image/jpeg|image/pjpeg|image/gif|image/png|image/x-png";
		$mime_array = explode('|', $mime);
		$max_size = 10000000;
		$max_width = 2000;
		$max_height = 2000;
		
		$uploader = new CommunityImageUploader($this->upload_dir, $mime_array, $max_size, $max_width, $max_height);
		$count = 0;
		$ret = array();
		
		$_SESSION['image'] = array();
		$sessid = session_id();
		
		for($i=0; $i<$file_count; $i++){
			if($_FILES[$name]['error'][$i]==0 && $uploader->fetchMedia($name, $i)){
				$tmp_filename = md5(date('Y-m-d H:i:s'). $sessid. $i);
				if(!$uploader->checkFileNameLength($this->upload_dir.'/'.$tmp_filename)){
					continue;
				}
				$uploader->setTargetFileName($tmp_filename.'.'.$uploader->getExt());
				if($uploader->upload()){
					$filename = $this->upload_dir.'/'.$uploader->getSavedFileName();
					$thumb_filename = $this->upload_dir.'/thumbnail'.$thumb_id.'/'.basename($filename);
					if(!$this->createThumbnail($filename, $thumb_id, $thumb_filename)){
						continue;
					}
					$_SESSION['image'][$i]['filename'] = basename($filename);
					
					$ret[] = array(
						'url' => _CM_IMAGE_LOAD_URL.'?f='.basename($filename),
						'url_src' => _CM_IMAGE_LOAD_URL.'?f='.basename($filename).'&t='.$thumb_id,
					);
					if(++$count == _CM_IMAGE_UPLOAD_MAX){
						break;
					}
				}
			}
		}
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
	// ꎞ摜̍폜
	function deleteImageTemp()
	{
		if(isset($_SESSION['image']) && is_array($_SESSION['image']) && $this->dir_exists){
			foreach($_SESSION['image'] as $image){
				if(!preg_match('/^[0-9a-f]{32}/i', $image['filename'])){
					continue;
				}
				@unlink($this->upload_dir. '/'. $image['filename']);
				@unlink($this->upload_dir. '/thumbnail2/'. $image['filename']);
			}
			unset($_SESSION['image']);
		}
	}
	
	//--------------------------------------------------------------------------
	
	// 摜̃Abv[h
	function uploadImage($prefix, $target, $target_id)
	{
		global $xoopsUser;
		if(!isset($_SESSION['image']) || !is_array($_SESSION['image']) || !$this->dir_exists || !is_object($xoopsUser)){
			return false;
		}
		$own_uid = $xoopsUser->getVar('uid');
		
		$thumb_id = _CM_IMAGE_SIZE_M;
		
		$file_ids = array();
		$index = 0;
		
		foreach($_SESSION['image'] as $image){
			if(!preg_match('/^[0-9a-f]{32}/i', $image['filename'])){
				continue;
			}
			
			$temp_filepath = $this->upload_dir. '/'. $image['filename'];
			if(!@file_exists($temp_filepath)){
				continue;
			}
			if(!($fileinfo = @pathinfo($temp_filepath))){
				continue;
			}
			
			// ꎞt@C̖O^CX^vɊÂĕϊ
			$timestamp_name = uniqid($prefix).$index.'.'.$fileinfo['extension'];
			$new_filename = $this->upload_dir.'/'.$timestamp_name;
			if(!@rename($this->upload_dir.'/'.$image['filename'], $new_filename)){
				continue;
			}
			
			// ꎞTlC摜()l[
			$thumb_dir = $this->upload_dir.'/thumbnail'.$thumb_id.'/';
			if(!@rename($thumb_dir.$image['filename'], $thumb_dir.$timestamp_name)){
				continue;
			}
			
			// TlC摜()𐶐
			if(!$this->createThumbnail($new_filename, _CM_IMAGE_SIZE_S, $this->upload_dir.'/thumbnail1/'.$timestamp_name)){
				continue;
			}
			// TlC摜()𐶐
			if(!$this->createThumbnail($new_filename, _CM_IMAGE_SIZE_L, $this->upload_dir.'/thumbnail3/'.$timestamp_name)){
				continue;
			}
			
			// ۑt@Ce[uɊi[
			$new_file =& $this->create();
			$new_file->setVars(array(
				'filename' => $timestamp_name,
				'target' => $target,
				'target_id' => $target_id,
				'uid' => $own_uid,
			));
			if($ret = $this->insert($new_file)){
				$file_ids[] = $ret;
			}
			unset($new_file);
			$index++;
		}
		unset($_SESSION['image']);
		
		return $file_ids;
	}
	
	//--------------------------------------------------------------------------
	
	function delete(&$obj)
	{
		if( !$this->enabled() || strtolower(get_class($obj)) != strtolower($this->obj_class) || !$this->dir_exists){
			return false;
		}
		$filename = $obj->getVar('filename');
		
		$sql = "DELETE FROM ".$this->prefix($this->table_name).
				" WHERE ".$this->primary_key."='".intval($obj->getVar($this->primary_key))."'";
		$result = $this->db->query($sql);
		if (!$result) {
			return false;
		}
		
		@unlink($this->upload_dir.'/'.$filename);
		for($i=1; $i<=3; $i++){
			@unlink($this->upload_dir.'/thumbnail'.$i.'/'.$filename);
		}
		return true;
	}
	
	//--------------------------------------------------------------------------
	
	function createThumbnail($filename, $thumb_id, $dst_filename=NULL)
	{
		if(!@file_exists($filename) || !$this->dir_exists){
			return false;
		}
		if(!function_exists('getimagesize') || !($sizeinfo = getimagesize($filename))){
			return false;
		}
		if(!($path_parts = @pathinfo($filename))){
			return false;
		}
		
		$w_max_array = array(_CM_IMAGE_SIZE_S => 80, _CM_IMAGE_SIZE_M => 120, _CM_IMAGE_SIZE_L => 180);
		$h_max_array = array(_CM_IMAGE_SIZE_S => 80, _CM_IMAGE_SIZE_M => 120, _CM_IMAGE_SIZE_L => 180);
		
		$w_max = $w_max_array[$thumb_id];
		$h_max = $h_max_array[$thumb_id];
		
		$width = $sizeinfo[0];
		$height = $sizeinfo[1];
		
		$w_ratio = ($width > $w_max)? $w_max/$width : 1.0;
		$h_ratio = ($height > $h_max)? $h_max/$height : 1.0;
		$ratio = ($w_ratio > $h_ratio)? $h_ratio : $w_ratio;
		
		if(is_null($dst_filename)){
			$thumb_filename = $this->upload_dir.'/thumbnail'.$thumb_id.'/'.basename($filename);
		}
		else{
			$thumb_filename = $dst_filename;
		}
		
		if($ratio < 1){
			if(!function_exists('imagecreatetruecolor') || !function_exists('imagecopyresampled')){
				return false;
			}
			$ext = $path_parts['extension'];
			
			switch(strtolower($ext)){
				case 'gif':
					if(!function_exists('imagecreatefromgif') || !function_exists('imagegif')){
						return false;
					}
					$source = imagecreatefromgif($filename);
					$output_func = 'imagegif';
					break;
				case 'jpg':
					if(!function_exists('imagecreatefromjpeg') || !function_exists('imagejpeg')){
						return false;
					}
					$source = imagecreatefromjpeg($filename);
					$output_func = 'imagejpeg';
					break;
				case 'png':
					if(!function_exists('imagecreatefrompng') || !function_exists('imagepng')){
						return false;
					}
					$source = imagecreatefrompng($filename);
					$output_func = 'imagepng';
					break;
				default:
					return false;
			}
			
			$new_width = intval($width * $ratio);
			$new_height = intval($height * $ratio);
			
			$thumb = imagecreatetruecolor($new_width, $new_height);
			imagecopyresampled($thumb, $source, 0, 0, 0, 0, $new_width, $new_height, $width, $height);
			return @call_user_func($output_func, $thumb, $thumb_filename);
		}
		else{
			return @copy($filename, $thumb_filename);
		}
	}
	
}

//******************************************************************************

?>
