<?php
class add_execAction extends topicAction
{

function dispatch(&$context)
{
	global $xoopsUser;
	
	if($this->isGuest() || !$this->validateToken('TOPIC_ADD')){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	$own_uid = $xoopsUser->getVar('uid');
	
	$cid = $this->getIntRequest('cid');
	if(!isset($cid)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	// ߥ˥ƥμ
	$commu_handler =& CM_CommunityHandler::getInstance();
	$community =& $commu_handler->get($cid);
	if(!is_object($community) || !$community->checkAuthority()){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$name = $this->getTextRequest('topic_name', APP_REQUEST_SESSION);
	$body = $this->getTextRequest('topic_body', APP_REQUEST_SESSION);
	
	if(!isset($name) || !isset($body)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$r_datetime = date('Y-m-d H:i:s');
	$r_date = date('Y-m-d');
	
	$topic_handler =& CM_TopicHandler::getInstance();
	$new_topic =& $topic_handler->create();
	
	$new_topic->setVars(array(
		'c_commu_id' => $cid,
		'name' => $name,
		'r_datetime' => $r_datetime,
		'r_date' => $r_date,
		'uid' => $own_uid,
	));
	
	if($tid = $topic_handler->insert($new_topic)){
		$comment_handler =& CM_TopicCommentHandler::getInstance();
		$new_comment =& $comment_handler->create();
		
		$new_comment->setVars(array(
			'c_commu_topic_id' => $tid,
			'c_commu_id' => $cid,
			'uid' => $own_uid,
			'body' => $body,
			'r_datetime' => $r_datetime,
			'r_date' => $r_date,
			'number' => 0,
		));
		
		if($tcid = $comment_handler->insert($new_comment)){
			
			// ȥԥåΥȤФƲź
			$image_handler =& CM_ImageHandler::getInstance();
			$image_ids = $image_handler->uploadImage('t', 2, $tcid);
			
			// ȥԥåΥȤФƥեź
			$file_handler =& CM_FileHandler::getInstance();
			$file_ids = $file_handler->uploadFile('t', 2, $tcid);
			
			// ٥
			if(include_once(APP_TRUST_PATH.'/include/notification.php')){
				$tags = array(
					'COMMU_NAME' => $community->getVar('name'),
					'TOPIC_NAME' => $new_topic->getVar('name'),
					'TOPIC_BODY' => $new_comment->getVar('body', 'e'),	// disallow HTML
					'AUTHOR_NAME' => $xoopsUser->getVar('uname'),
					'TOPIC_URI' => _CM_URL_TOPIC.'&tid='.$tid,
				);
				// ߥ˥ƥСʳˤʤ
				$c_member_obj_list =& $community->getMemberObjects();
				$c_member_ids = array();
				foreach($c_member_obj_list as $c_member_obj){
					$c_member_ids[] = $c_member_obj->getVar('uid');
				}
				xsns_main_trigger_event('topic', $cid, 'create', $tags, $c_member_ids);
			}
			
			$xoopsUser->incrementPost();
			$this->clearSessionValues();
			
			redirect_header(_CM_URL_TOPIC.'&tid='.$tid, 2, _CM_TOPIC_ADD_OK);
		}
	}
	redirect_header(_CM_URL_TOPIC.'&'.APP_ACTION_ARG.'=add&cid='.$cid, 2, _CM_TOPIC_ADD_NG);
}

function clearSessionValues()
{
	unset(
		$_SESSION['topic_name'],
		$_SESSION['topic_body']
	);
}

}
?>
