<?php

class defaultAction extends indexAction
{

function dispatch(&$context)
{
	$limit = 10;
	
	$this->clearSessionValues();
	
	$cid = $this->getIntRequest('cid', APP_REQUEST_GET);
	if($cid > 0){
		$context->setAttributes('commu', $this->getCommunityDetail($cid));
		return "detail";
	}
	
	$start = $this->getIntRequest('s', APP_REQUEST_GET);
	if(!isset($start) || $start<0){
		$start = 0;
	}
	
	$cat_id = $this->getIntRequest('cat_id', APP_REQUEST_GET);
	$keyword = $this->getTextRequest('keyword', APP_REQUEST_GET);
	$sort_method = $this->getTextRequest('sort', APP_REQUEST_GET);
	
	$commu_handler =& CM_CommunityHandler::getInstance();
	
	$criteria = new CriteriaCompo();
	$criteria->setLimit($limit);
	$criteria->setStart($start);
	
	if($cat_id > 0){
		$criteria->add(new Criteria('c_commu_category_id', $cat_id));
	}
	if($keyword != ''){
		$kw_criteria = new CriteriaCompo(new Criteria('name', '%'.$keyword.'%', 'LIKE'));
		$kw_criteria->add(new Criteria('info', '%'.$keyword.'%', 'LIKE'), 'OR');
		$criteria->add($kw_criteria);
	}
	
	switch($sort_method){
		case 'member':
			$criteria->setSort('member_count');
			$criteria->setOrder('DESC');
			break;
		
		case 'date':
		default:
			$criteria->setSort('cc.r_datetime');
			$criteria->setOrder('DESC');
			break;
	}
	$commu_list =& $commu_handler->getList($criteria);
	$commu_total = $commu_handler->getCount($criteria);
	
	$base_url = _CM_URL_COMMU.'?';
	if($cat_id > 0){
		$base_url .= "&cat_id=".$cat_id;
	}
	if($keyword != ''){
		$base_url .= "&keyword=".rawurlencode($keyword);
	}
	
	if($sort_method=='member' || $sort_method=='date'){
		$base_url .= '&sort='.$sort_method;
	}
	
	$category_handler =& CM_CategoryHandler::getInstance();
	$category_parent_handler =& CM_CategoryParentHandler::getInstance();
	$category_selector = $category_handler->getSelectorHtml('cat_id', 0, _CM_INDEX_CATEGORY_NO);
	$category_list =& $category_parent_handler->getList();
	
	$pager = $this->getPageSelector($base_url, 
				$start, $limit, count($commu_list), $commu_total);
	
	if(count($commu_list)==0){
		$pager['description'] = _CM_INDEX_COMMU_COUNT0;
	}
	
	$keyword_option = empty($keyword)? '' : '&keyword='.rawurlencode($keyword);
	$cat_id_option = empty($cat_id)? '' : '&cat_id='.$cat_id;
	
	$url = array(
		'sort_member' => '?sort=member'. $keyword_option. $cat_id_option,
		'sort_date'   => '?sort=date'. $keyword_option. $cat_id_option,
	);
	
	$context->setAttributes('is_guest', $this->isGuest());
	$context->setAttributes('keyword', $keyword);
	$context->setAttributes('url', $url);
	$context->setAttributes('category_selector', $category_selector);
	$context->setAttributes('category_list', $category_list);
	$context->setAttributes('pager', $pager);
	$context->setAttributes('commu_list', $commu_list);
}
//------------------------------------------------------------------------------

function getCommunityDetail($cid)
{
	global $xoopsUser;
	
	$commu_handler =& CM_CommunityHandler::getInstance();
	$c_member_handler =& CM_MemberHandler::getInstance();
	$user_handler =& CM_UserHandler::getInstance();
	$image_handler =& CM_ImageHandler::getInstance();
	$topic_handler =& CM_TopicHandler::getInstance();
	$comment_handler =& CM_TopicCommentHandler::getInstance();
	
	// ߥ˥ƥμ
	$community =& $commu_handler->get($cid);
	if(!is_object($community)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$community->setStatistics();
	$topic_list =& $community->getTopicList(10);
	
	// ߥ˥ƥСμ
	$c_member_obj_list =& $community->getMemberObjects(9, 0, true);
	$c_member_list = array();
	foreach($c_member_obj_list as $c_member_obj){
		$c_member_list[] =& $c_member_obj->getInfo();
	}
	
	$c_member_count = count($c_member_obj_list);
	if($c_member_count < 9){
		for($i=0; $i<9-$c_member_count; $i++){
			$c_member_list[] = array();
		}
	}
	
	$uid_admin = $community->getVar('uid_admin');
	$own_uid = ($this->isXoopsUser()) ? $xoopsUser->getVar('uid') : 0;
	
	if($c_member_handler->get($cid, $own_uid)){
		$is_member = true;
		$is_admin = ($own_uid == $uid_admin)? true : false;
	}
	else{
		$is_member = $is_admin = false;
	}
	
	$commu_auth = $community->getAuthority();
	$public_flag = $community->getVar('public_flag');
	
	$admin_obj =& $user_handler->get($uid_admin);
	$admin_name = (is_object($admin_obj))? $admin_obj->getVar('uname') : "";
	
	$public_flag_desc = array(
		1 => _CM_INDEX_DETAIL_PUBLIC_L1,
		2 => _CM_INDEX_DETAIL_PUBLIC_L2,
		3 => _CM_INDEX_DETAIL_PUBLIC_L3,
	);
	
	$ret = array(
		'id' => $cid,
		'name' => $community->getVar('name'),
		'info' => $community->getVar('info'),
		'r_date' => $community->getVar('r_date'),
		'image' => $community->getImage(_CM_IMAGE_SIZE_L),
		'category' => $community->getCategoryName(),
		'public' => $public_flag_desc[$public_flag],
		'admin_name' => $admin_name,
		'admin_url' => _CM_URL_MYPAGE.'&uid='.$uid_admin,
		'statistics' => $community->getStatistics(),
		'member_list' => $c_member_list,
		'member_count' => $community->getMemberCount(),
		'topic_list' => $topic_list,
		'topic_count' => $community->getTopicCount(),
		
		'show_commu_join' => (!$is_member && $commu_auth > _CM_AUTH_GUEST) ? true : false,
		'show_commu_leave' => ($is_member && !$is_admin) ? true : false,
		'show_commu_notify' => ($is_member) ? true : false,
		'show_commu_config' => ($commu_auth >= _CM_AUTH_ADMIN) ? true : false,
		'show_topic_list' => ($public_flag!=3 || $commu_auth>=_CM_AUTH_MEMBER) ? true : false,
		'show_topic_add' => ($commu_auth >= _CM_AUTH_MEMBER) ? true : false,
		'show_send_message' => ($commu_auth >= _CM_AUTH_MEMBER) ? true : false,
		'show_member_config' => ($commu_auth >= _CM_AUTH_ADMIN) ? true : false,
	);
	return $ret;
}
//------------------------------------------------------------------------------

function clearSessionValues()
{
	unset(
		$_SESSION['community_name'], 
		$_SESSION['community_info'], 
		$_SESSION['community_cat_id'], 
		$_SESSION['community_public_id'],
		$_SESSION['topic_name'],
		$_SESSION['topic_body'],
		$_SESSION['topic_comment'],
		$_SESSION['msg_title'], 
		$_SESSION['msg_body']
	);
}
//------------------------------------------------------------------------------

}

?>