<?php
class del_execAction extends fileAction
{

function dispatch(&$context)
{
	if(!$this->validateToken('FILE_DELETE')){
		redirect_header('index.php', 2, _NOPERM);
	}

	$image_id = $this->getIntRequest('image_id');
	$file_id = $this->getIntRequest('file_id');
	
	if(!$this->checkAuthority($image_id, $file_id)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$url = _CM_URL_COMMU;
	
	if($image_id > 0){
		$image_handler =& CM_ImageHandler::getInstance();
		$image =& $image_handler->get($image_id);
		
		if($image_handler->delete($image)){
			$msg = _CM_FILE_DEL_IMAGE_OK;
			$url = $this->getRedirectURL($image->getVar('target'), $image->getVar('target_id'));
		}
		else{
			$msg = _CM_FILE_DEL_IMAGE_NG;
		}
	}
	elseif($file_id > 0){
		$file_handler =& CM_FileHandler::getInstance();
		$file =& $file_handler->get($file_id);
		
		if($file_handler->delete($file)){
			$msg = _CM_FILE_DEL_FILE_OK;
			$url = $this->getRedirectURL($file->getVar('target'), $file->getVar('target_id'));
		}
		else{
			$msg = _CM_FILE_DEL_FILE_NG;
		}
	}
	else{
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	if(is_null($url)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	redirect_header($url, 2, $msg);
}

//------------------------------------------------------------------------------

function getRedirectURL($target, $target_id)
{
	if($target == 1){
		return _CM_URL_COMMU.'?'.APP_ACTION_ARG.'=edit&cid='.$target_id;
	}
	elseif($target == 2){
		$comment_handler =& CM_TopicCommentHandler::getInstance();
		$comment =& $comment_handler->get($target_id);
		if(!is_object($comment)){
			return NULL;
		}
		$tid = $comment->getVar('c_commu_topic_id');
		$num = $comment->getVar('number');
		return _CM_URL_TOPIC.'&'.APP_ACTION_ARG.'=edit&tid='.$tid.'&n='.$num;
	}
	return NULL;
}

//------------------------------------------------------------------------------

}
?>
