﻿#undef NDEBUG
#include <assert.h>

#include <windows.h>
#include "win32.h"
#include "win32_print.h"
#include "win32_vector.h"
#include "tlsdecl.h"

#include <stdint.h>

#define DBG(format, ...) win32_printfA("[WMAIN] " format "\n", ## __VA_ARGS__)

struct win32_module
{
	HMODULE BaseAddress = 0;
	DWORD   SizeOfImage;
	LPVOID  EntryPoint;
	LONG    TlsIndex = -1;
#if 0x0
	WCHAR   FileFullPath[_MAX_PATH+1] = { 0 };
	WCHAR   FileLocalName[_MAX_PATH+1] = { 0 };
#else
	WCHAR   FileFullPath[_MAX_PATH+1];
	WCHAR   FileLocalName[_MAX_PATH+1];
#endif
};

static
void win32_module_vector_clear(win32_module **vector)
{
	win32_global_vector_resize(sizeof(**vector), (char **)vector, 0);
}

static
size_t win32_module_vector_size(win32_module **vector)
{
	return win32_global_vector_size(sizeof(**vector), (char **)vector);
}

static
void win32_module_vector_push_back(win32_module **vector, win32_module *val)
{
	win32_global_vector_push_back(sizeof(**vector), (char **)vector, (char *)val);
}

int wmain(int argc, wchar_t *argv[])
{
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);
	
	win32_debug_set(true);

	DBG("wmain() called");
	DBG("sizeof(LPVOID)=%u", sizeof(LPVOID));
	
	win32_module v_module;
	DBG("v_module.TlsIndex=%d", v_module.TlsIndex);
	
	static win32_module *v_module_vector = NULL;
	for(int i=0; i<10; i++)
	{
		win32_module v_module2;
		v_module2.FileFullPath[0] = 0;
		v_module2.FileLocalName[0] = 0;
		DBG("[%02d] sizeof(v_module2)=%u", i, sizeof(v_module2));
		DBG("[%02d] v_module2.BaseAddress=0x%08x", i, v_module2.BaseAddress);
		DBG("[%02d] v_module2.FileFullPath=%ls", i, v_module2.FileFullPath);
		DBG("[%02d] v_module2.TlsIndex=%d (before)", i, v_module2.TlsIndex);
		v_module2.TlsIndex = 1234;
		DBG("[%02d] v_module2.TlsIndex=%d (after)", i, v_module2.TlsIndex);
		win32_module_vector_push_back(&v_module_vector, &v_module2);
	}
	size_t v_size = win32_module_vector_size(&v_module_vector);
	DBG("v_size=%u", v_size);
	for(size_t i=0; i<win32_module_vector_size(&v_module_vector); i++)
	{
		win32_module &v_module3 = v_module_vector[i];
		DBG("[%02u] v_module3.BaseAddress=0x%08x", i, v_module3.BaseAddress);
		DBG("[%02u] v_module3.FileFullPath=%ls", i, v_module3.FileFullPath);
		DBG("[%02u] v_module3.TlsIndex=%d (before)", i, v_module3.TlsIndex);
	}

#if 0x1
	HANDLE v_thread_heap = win32_thread_heap();
	DBG("wmain(): v_thread_heap=0x%08x", v_thread_heap);
	void *v_memory = win32_thread_malloc(1024);
	DBG("wmain(): v_memory=0x%08x", v_memory);
	void *v_memory2 = win32_thread_malloc(1024);
	DBG("wmain(): v_memory2=0x%08x", v_memory2);
	size_t v_size2 = win32_thread_memlen(v_memory2);
	DBG("wmain(): v_size2=%u", v_size2);
	void *v_memory3 = win32_thread_realloc(v_memory2, 1026);
	DBG("wmain(): v_memory3=0x%08x", v_memory3);
	size_t v_size3 = win32_thread_memlen(v_memory3);
	DBG("wmain(): v_size3=%u", v_size3);
	win32_thread_free(v_memory);
#endif
	static TLS_VARIABLE_DECL char *s_vector = NULL;
	size_t v_memlen1 = win32_thread_memlen(s_vector);
	DBG("wmain(A): v_memlen1=%u", v_memlen1);
	DBG("wmain(B): win32_thread_char_size(&s_vector)=%u", win32_thread_char_size(&s_vector));
	win32_thread_char_resize(&s_vector, 5);
	size_t v_memlen2 = win32_thread_memlen(s_vector);
	DBG("wmain(C): v_memlen2=%u", v_memlen2);
	DBG("wmain(D): win32_thread_char_size(&s_vector)=%u", win32_thread_char_size(&s_vector));
	static TLS_VARIABLE_DECL char *s_vector2 = NULL;
	win32_thread_char_push_back(&s_vector2, 'a');
	win32_thread_char_push_back(&s_vector2, 'b');
	win32_thread_char_push_back(&s_vector2, ' ');
	win32_thread_char_push_back(&s_vector2, 'c');
	win32_thread_char_push_back(&s_vector2, 0);
	win32_thread_char_insert(&s_vector2, 0, 'Z');
	DBG("wmain(E): win32_thread_char_size(&s_vector2)=%u", win32_thread_char_size(&s_vector2));
	DBG("wmain(F): s_vector2=%s", s_vector2);
	char erase1 = win32_thread_char_erase(&s_vector2, 0);
	char erase2 = win32_thread_char_erase(&s_vector2, 1);
	DBG("wmain(G): s_vector2(after erase)=%s", s_vector2);
	DBG("wmain(H): win32_thread_char_size(&s_vector2)=%u", win32_thread_char_size(&s_vector2));
	//win32_thread_char_resize(&s_vector2, 0);
	//win32_thread_char_clear(&s_vector2);
	DBG("wmain(I): ワイド文字列1＝%S", L"漢字");
	DBG("wmain(J): ワイド文字列2＝%s", L"漢字");
	
	win32_thread_char_reserve(&s_vector2, 20);
	DBG("wmain(K): win32_thread_char_size(&s_vector2)=%u", win32_thread_char_size(&s_vector2));
	win32_thread_char_reserve(&s_vector2, 15);
	DBG("wmain(L): win32_thread_char_size(&s_vector2)=%u", win32_thread_char_size(&s_vector2));
	
	char c0 = win32_thread_char_get(&s_vector2, 0);
	DBG("wmain(M): c0=%c", c0);
	win32_thread_char_set(&s_vector2, 4096, 'X');
	char c4096 = win32_thread_char_get(&s_vector2, 4096);
	DBG("wmain(N): c4096=%d (%c)", c4096, c4096);
	DBG("wmain(O): win32_thread_char_size(&s_vector2)=%u", win32_thread_char_size(&s_vector2));

	return 0;
}
