﻿#undef NDEBUG

#include "sbox.h"
#include "wine.h"
//#include "syncprint.h"
//#include "sbox_print.h"

#include <windows.h>
#include <assert.h>
#include <process.h> // _beginthread(), _beginthreadex()

//#include <stdint.h>

#include "strconv.h"
#include "tlsdecl.h"

//using namespace std;

TLS_VARIABLE_DECL int tls_int = 0;

#define printf sync_printf

//void Bounce(PVOID p)
unsigned __stdcall Bounce(void *p)
{
	UNREFERENCED_PARAMETER(p);
	printf("[Bounce] Bounce() called: p=0x%08x (%s)\n", p, p);
	assert(g_sbox_process);
	assert(g_sbox_thread);
	assert(g_sbox_thread->f_teb != g_sbox_process->f_teb);
	PWINE_TEB v_teb = g_sbox_thread->f_teb;
	printf("[Bounce] v_teb=0x%08x\n", v_teb);
	printf("[Bounce] sub thread tls value(1) = %d\n", tls_int);
	tls_int = -25;
	printf("[Bounce] sub thread tls value(2) = %d\n", tls_int);
	std::wstring v_wstr = wstring_printf(L"%d-%-%", 1, 2, 3);
    //_endthreadex(0);
    return 0;//コンパイラの警告を殺す
}

int wmain(int argc, wchar_t *argv[])
{
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);

	assert(g_sbox_process);
	assert(g_sbox_thread == NULL);
	assert(g_sbox_process->f_root_thread == NULL);
	g_sbox_process->alloc_main_thread();
	assert(g_sbox_thread);
	assert(g_sbox_process->f_root_thread == g_sbox_thread);

	PWINE_TEB v_teb = g_sbox_thread->f_teb;
	for(ULONG i=0; i<g_sbox_process->f_num_extended_tls; i++)
	{
		printf("[Main] v_teb->ThreadLocalStoragePointer[%02d]=0x%08x\n", i, ((DWORD *)v_teb->ThreadLocalStoragePointer)[i]);
	}

	printf("[Main] main thread tls value(1) = %d\n", tls_int);
	tls_int = 5678;
    HANDLE v_thread_handle = (HANDLE)_beginthreadex(NULL, 0, Bounce, (void *)"paramです。", 0, NULL);
	printf("[Main] main thread tls value(2) = %d\n", tls_int);

    WaitForSingleObject(v_thread_handle, INFINITE); /* スレッドが終了するまで待つ。 */
    CloseHandle(v_thread_handle); /* ハンドルを閉じる */

	printf("[Main] main thread tls value(3) = %d\n", tls_int);

	//WineTestRoutine(v_teb->ThreadLocalStoragePointer);
	//Sleep(3000);
	//exit(0);
	return 0;
}
