#include <QtCore>
#include <QtScript>
#if 0x0
#include <QtGui>
#include <QtScriptTools>
#include <QAction>
#endif
#include <stdio.h>
#include <windows.h>

//#include <QtScript/QScriptEngine>
//#include <QtScript/QScriptValue>
//#ifndef QT_NO_SCRIPTTOOLS
//#include <QtScriptTools/QScriptEngineDebugger>
//#endif

// http://shibu.jp/techmemo/qtscript_ja.html
static QScriptValue consoleLogForJS(QScriptContext* context, QScriptEngine* engine)
{
    QStringList list;
    for(int i=0; i<context->argumentCount(); ++i)
    {
        QScriptValue param(context->argument(i));
        list.append(param.toString());
    }
    qDebug() << list.join(" ");
    return engine->undefinedValue();
}

int main(int argc, char **argv)
{
	Q_UNUSED(argc);
	Q_UNUSED(argv);
	QCoreApplication app(argc, argv);

	printf("this is main.exe: %d\n", 1234);
	qDebug() << app.arguments();
	qDebug() << QDir::currentPath() << flush;

	QScriptEngine engine;
#if 0x0
	QScriptEngineDebugger* debugger = new QScriptEngineDebugger();
	debugger->attachTo(&engine);
	debugger->action(QScriptEngineDebugger::InterruptAction)->trigger();
#endif
	//QScriptValue result = engine.evaluate("return 1234");
	//QScriptValue result = engine.evaluate("Math.pow(2, 10)");
	QScriptValue result = engine.evaluate("return Math.pow(2, 10)", "myfile1.js");
	if (result.isError()) {
		qDebug() << result.property("fileName").toString() << result.property("lineNumber").toInt32() << result.toString();
	}
	else
	{
		qDebug() << result.toInteger();
	}
	QScriptValue globalObject = engine.globalObject();
	QScriptValue console = engine.newObject();
	globalObject.setProperty("console", console);
	QScriptValue consoleLog = engine.newFunction(consoleLogForJS);
	console.setProperty("log", consoleLog);
	result = engine.evaluate("console.log('a', 'b', 'c')", "myfile2.js");
	if (result.isError()) {
		qDebug() << result.property("fileName").toString() << result.property("lineNumber").toInt32() << result.toString();
	}

	return 0;
}
