﻿#ifndef _STRCONV_H_
#define _STRCONV_H_

#include <windows.h>
#include <string>

inline std::wstring cp_to_wide(const std::string &s, UINT codepage)
{
	int slength = (int)s.length();
	int len = MultiByteToWideChar(codepage, 0, s.c_str(), slength, 0, 0); 
	std::wstring result(len, L'\0');
	MultiByteToWideChar(codepage, 0, s.c_str(), slength, &result[0], len);
	return result;
}
inline std::string wide_to_cp(const std::wstring &s, UINT codepage)
{
	int slength = (int)s.length();
	int len = WideCharToMultiByte(codepage, 0, s.c_str(), slength, 0, 0, 0, 0); 
	std::string result(len, '\0');
	WideCharToMultiByte(codepage, 0, s.c_str(), slength, &result[0], len, 0, 0); 
	return result;
}

static std::wstring utf8_to_wide(const std::string &s)
{
	return cp_to_wide(s, CP_UTF8);
}
static std::string wide_to_utf8(const std::wstring &s)
{
	return wide_to_cp(s, CP_UTF8);
}

static std::wstring ansi_to_wide(const std::string &s)
{
	return cp_to_wide(s, CP_ACP);
}
static std::string wide_to_ansi(const std::wstring &s)
{
	return wide_to_cp(s, CP_ACP);
}

static std::wstring sjis_to_wide(const std::string &s)
{
	return cp_to_wide(s, 932);
}
static std::string wide_to_sjis(const std::wstring &s)
{
	return wide_to_cp(s, 932);
}

static std::string ansi_to_utf8(const std::string &s)
{
	std::wstring wide = ansi_to_wide(s);
	return wide_to_utf8(wide);
}
static std::string utf8_to_ansi(const std::string &s)
{
	std::wstring wide = utf8_to_wide(s);
	return wide_to_ansi(wide);
}

static std::string sjis_to_utf8(const std::string &s)
{
	std::wstring wide = sjis_to_wide(s);
	return wide_to_utf8(wide);
}
static std::string utf8_to_sjis(const std::string &s)
{
	std::wstring wide = utf8_to_wide(s);
	return wide_to_sjis(wide);
}

#endif /* _STRCONV_H_ */
