﻿#define _CRT_SECURE_NO_WARNINGS

#include <windows.h>
#include <stdio.h>
#include <iostream>

#include <lua.hpp>
#include <math.h>
#include "strconv.h"

static char *read_file_contents(std::wstring a_filename)
{
	std::wcout << a_filename << std::endl;
	FILE *f = _wfopen(a_filename.c_str(), L"rb");
	if(f==NULL) return NULL;
	fseek(f, 0, SEEK_END);
	long fsize = ftell(f);
	fseek(f, 0, SEEK_SET);
	char *string = (char *)malloc(fsize + 1);
	fread(string, fsize, 1, f);
	fclose(f);
	string[fsize] = 0;
	return string;
}

static std::string read_file_contents_2(std::wstring a_filename)
{
	std::wcout << a_filename << std::endl;
	FILE *f = _wfopen(a_filename.c_str(), L"rb");
	if(f==NULL) return "";
	fseek(f, 0, SEEK_END);
	long fsize = ftell(f);
	fseek(f, 0, SEEK_SET);
	std::string s(fsize, '\0');
	fread(&s[0], fsize, 1, f);
	fclose(f);
	return s;
}

static __int64 read_file_contents_3(std::wstring a_filename, std::string &a_buffer)
{
	std::wcout << a_filename << std::endl;
	FILE *f = _wfopen(a_filename.c_str(), L"rb");
	if(f==NULL) return -1;
	fseek(f, 0, SEEK_END);
	long fsize = ftell(f);
	printf("fsize(1)=%d\n", fsize);
	fseek(f, 0, SEEK_SET);
	a_buffer.resize(fsize, '\0');
	printf("fsize(2)=%d\n", fsize);
	size_t v_read = fread(&a_buffer[0], 1, fsize, f);
	printf("v_read=%u\n", v_read);
	fclose(f);
	a_buffer.resize(v_read);
	return v_read;
}

static int l_sin(lua_State *lua) {
	//luaL_argerror (lua_State *L, int narg, const char *extramsg);
	int n = lua_gettop(lua);
	std::cout << "l_sin(): n=" << n << std::endl;
    double d = luaL_checknumber(lua, 1);
    lua_pushnumber(lua, sin(d));
    return 1;
}

static int l_pass_str_1(lua_State *lua)
{
	int n = lua_gettop(lua);
	std::cout << "l_pass_str_1(): n=" << n << std::endl;
	const char *v_arg_1 = luaL_checkstring(lua, 1);
#if 0x1
	std::cout << "l_pass_str_1(): [v_arg_1] " << v_arg_1 << std::endl;
	std::cout << "l_pass_str_1(): [utf8_to_sjis(v_arg_1).c_str()] " << utf8_to_sjis(v_arg_1).c_str() << std::endl;
#else
	wxString v_wx_str = wxString::FromUTF8(v_arg_1);
	std::wstring v_wstr = v_wx_str.ToStdWstring();
	std::cout << "[wxConvLocal] " << v_wx_str.mb_str(wxConvLocal) << std::endl;
	std::cout << "[wxConvUTF8] " << v_wx_str.mb_str(wxConvUTF8) << std::endl;
	std::wcout << "[v_wstr.length()] " << v_wstr.length() << std::endl;
	printf("v_wstr.c_str()=%S\n", v_wstr.c_str());
	std::wcout << "[v_wstr.c_str()] " << v_wstr.c_str() << std::endl;
	//std::wcout << "[.ToStdWstring().c_str()] " << v_wx_str.ToStdWstring().c_str() << std::endl;
	//std::wcout << "[.c_str()] " << v_wx_str.c_str() << std::endl;
#endif
#if 0x1
    lua_pushnil(lua);
    return 1;
#else
    return 0;
#endif
}

static const struct luaL_Reg mylib [] = {
    {"mysin", l_sin},
    {"pass_str_1", l_pass_str_1},
    {NULL, NULL}
};

int wmain(int argc, wchar_t *argv[])
{
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);
	printf("this is wmain()\n");
	printf("this is wmain(): 漢字\n");
	printf("sizeof(size_t)=%u\n", sizeof(size_t));
	
#if 0x0
	//_tsetlocale(LC_ALL, _T(""));
	_tsetlocale(LC_ALL, _T("Japanese_Japan.932"));
	std::wcout << L"あいうえお" << std::endl;
#endif

	//int iErr = 0;
	int v_err;
	lua_State *lua = luaL_newstate (); // Open Lua
	luaL_openlibs(lua);
#if LUA_VERSION_NUM >= 502
	luaL_newlib(lua, mylib);
	lua_setglobal(lua, "mylib");
#else
	luaL_register(lua, "mylib", mylib);
#endif
	
	//char *v_contents = read_file_contents(L"hw®.lua");
#if 0x1
	//std::string v_contents = read_file_contents_2(L"hw®.lua");
	//if(v_contents=="") return -1;
	std::string v_contents;
	if(read_file_contents_3(L"hw®.lua", v_contents)==-1)
	{
		return -1;
	}
	//printf("v_contents=%s\n", v_contents.c_str());
	printf("v_contents[sjis]=%s\n", utf8_to_sjis(v_contents).c_str());
	v_err = luaL_loadstring(lua, v_contents.c_str());
	printf("v_err(1)=%d\n", v_err);
#else
	//static char *read_file_contents_wx_2(std::wstring a_filename, wxCharBuffer &a_buffer)
	wxCharBuffer v_buffer;
	//if(read_file_contents_wx_2(L"hw®.lua", v_buffer)==-1) return -1;
	if(read_file_contents_wx_2(L"hw®.lua", v_buffer)==-1) return -1;
	printf("v_buffer.data()=%s\n", v_buffer.data());
	v_err = luaL_loadstring(lua, v_buffer.data());
	printf("v_err(1)=%d\n", v_err);
#endif
	//v_err = lua_pcall(lua, 0, LUA_MULTRET, 0);
	v_err = lua_pcall(lua, 0, 0, 0);
	printf("v_err(2)=%d\n", v_err);
	if(v_err != 0)
	{
		std::cout << "[lua_tostring(lua, -1)] " << lua_tostring(lua, -1) << std::endl;
	}
	lua_getglobal (lua, "helloWorld");
	if (lua_type(lua, lua_gettop(lua)) == LUA_TNIL) {
		std::cout<<"global variable not found : helloWorld"<<std::endl;
		/* error so we will just clear the Lua virtual stack and then return
if we do not clear the Lua stack, we leave garbage that will cause problems with later 
function calls from the application. we do this rather than use lua_error() because this function
is called from the application and not through Lua. */
		lua_settop (lua, 0);
		return -1;
	}		 
	lua_pcall (lua, 0, 0, 0);
	lua_close (lua);
	return 0;
}
