#define _CRT_SECURE_NO_WARNINGS

#include <windows.h>
#include <stdio.h>
#include <iostream>

#include <lua.hpp>
#include "strconv.h"

static char *read_file_contents(std::wstring a_filename)
{
	std::wcout << a_filename.c_str() << std::endl;
	FILE *f = _wfopen(a_filename.c_str(), L"rb");
	if(f==NULL) return NULL;
	fseek(f, 0, SEEK_END);
	long fsize = ftell(f);
	fseek(f, 0, SEEK_SET);
	char *string = (char *)malloc(fsize + 1);
	fread(string, fsize, 1, f);
	fclose(f);
	string[fsize] = 0;
	return string;
}

int wmain(int argc, wchar_t *argv[])
{
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);
	printf("this is wmain()\n");
	std::wcout.imbue(std::locale(""));
	//int iErr = 0;
	int v_err;
	lua_State *lua = luaL_newstate (); // Open Lua
	luaL_openlibs(lua);
	char *v_contents = read_file_contents(L"hw.lua");
	if(v_contents==NULL) return -1;
	//printf("v_contents=%s\n", v_contents);
	printf("v_contents[sjis]=%s\n", utf8_to_sjis(v_contents).c_str());
	v_err = luaL_loadstring(lua, v_contents);
	printf("v_err(1)=%d\n", v_err);
	v_err = lua_pcall(lua, 0, LUA_MULTRET, 0);
	printf("v_err(2)=%d\n", v_err);
	lua_getglobal (lua, "helloWorld");
	if (lua_type(lua, lua_gettop(lua)) == LUA_TNIL) {
		std::cout<<"global variable not found : helloworld"<<std::endl;
		/* error so we will just clear the Lua virtual stack and then return
if we do not clear the Lua stack, we leave garbage that will cause problems with later 
function calls from the application. we do this rather than use lua_error() because this function
is called from the application and not through Lua. */
		lua_settop (lua, 0);
		return -1;
	}		 
	lua_pcall (lua, 0, 0, 0);
	lua_close (lua);
	return 0;
}
