#include <QtCore>
#include <stdio.h>
#include <windows.h>

int main(int argc, char **argv)
{
	Q_UNUSED(argc);
	Q_UNUSED(argv);
	QCoreApplication app(argc, argv);
	printf("this is main.exe: %d\n", 1234);
	qDebug() << app.arguments();
	
	qDebug() << QDir::currentPath() << flush;

	PROCESS_INFORMATION pi;
	STARTUPINFOW si;

	ZeroMemory(&si,sizeof(si));
	si.cb=sizeof(si);

	printf("before CreateProcessW()\n");
	CreateProcessW(
		(LPCWSTR)L"sub.exe",
		(LPWSTR)L"a.exe b c d e f",
		NULL,
		NULL,
		FALSE,
		NORMAL_PRIORITY_CLASS,
	  	NULL,
		NULL,
		&si,
		&pi
		);
	printf("after CreateProcessW()\n");

	CloseHandle(pi.hThread);

	WaitForSingleObject(pi.hProcess,INFINITE);

	DWORD exitCode;
	if (!GetExitCodeProcess(pi.hProcess, &exitCode)) {
		return -1;
	}
	printf("exitCode=%d/%x\n", exitCode, exitCode);

	CloseHandle(pi.hProcess);
	
	qDebug("(1)");
	QProcess v_proc;
	v_proc.setProcessChannelMode(QProcess::MergedChannels);
	qDebug("(2)");
	v_proc.start("sub.exe");
	qDebug("(3)");
	v_proc.waitForFinished();
	qDebug("(4)");
	QByteArray v_bytes = v_proc.readAllStandardOutput();
	qDebug() << v_bytes;
	v_proc.close();
	qDebug("(5)");

	return 0;
}
