﻿#ifndef _WIN32_H_
#define _WIN32_H_

#include <windows.h>

#ifdef __cplusplus
extern "C" {
#endif
	/* DEBUG */
	void win32_debug_set(bool b);
	bool win32_debug_get(void);
	/* TLS */
	const char *win32_tls_callback_reason_label(DWORD dwReason);
	/* Raw Memory */
	void  *win32_heap_malloc(HANDLE heap, size_t size);
	void  *win32_heap_realloc(HANDLE heap, void *block, size_t size);
	size_t win32_heap_memlen(HANDLE heap, void *block);
	bool win32_heap_free(HANDLE heap, void *block);
	/* Vector */
	void   win32_vector_clear(HANDLE heap, DWORD width, char **vector);
	DWORD  win32_vector_size(HANDLE heap, DWORD width, char **vector);
	void   win32_vector_resize(HANDLE heap, DWORD width, char **vector, DWORD size);
	void   win32_vector_reserve(HANDLE heap, DWORD width, char **vector, DWORD size);
	void   win32_vector_get(HANDLE heap, DWORD width, char **vector, DWORD pos, char *val);
	void   win32_vector_set(HANDLE heap, DWORD width, char **vector, DWORD pos, char *val);
	void   win32_vector_push_back(HANDLE heap, DWORD width, char **vector, char *val);
	void   win32_vector_erase(HANDLE heap, DWORD width, char **vector, DWORD pos, char *val);
	void   win32_vector_insert(HANDLE heap, DWORD width, char **vector, DWORD pos, char *val);
	/* Global Heap */
	HANDLE win32_global_heap(void);
	//void *win32_global_malloc(size_t size);
	#define win32_global_malloc(...) win32_heap_malloc(win32_global_heap(), ## __VA_ARGS__)
	//void *win32_global_realloc(void *block, size_t size);
	#define win32_global_realloc(...) win32_heap_realloc(win32_global_heap(), ## __VA_ARGS__)
	//size_t win32_global_memlen(void *block);
	#define win32_global_memlen(...) win32_heap_memlen(win32_global_heap(), ## __VA_ARGS__)
	//void win32_global_free(void *block);
	#define win32_global_free(...) win32_heap_free(win32_global_heap(), ## __VA_ARGS__)
	//void   win32_global_vector_clear(DWORD width, char **vector);
	#define win32_global_vector_clear(...) win32_vector_clear(win32_global_heap(), ## __VA_ARGS__)
	//DWORD  win32_global_vector_size(DWORD width, char **vector);
	#define win32_global_vector_size(...) win32_vector_size(win32_global_heap(), ## __VA_ARGS__)
	//void   win32_global_vector_resize(DWORD width, char **vector, DWORD size);
	#define win32_global_vector_resize(...) win32_vector_resize(win32_global_heap(), ## __VA_ARGS__)
	//void   win32_global_vector_reserve(DWORD width, char **vector, DWORD size);
	#define win32_global_vector_reserve(...) win32_vector_reserve(win32_global_heap(), ## __VA_ARGS__)
	//void   win32_global_vector_get(DWORD width, char **vector, DWORD pos, char *val);
	#define win32_global_vector_get(...) win32_vector_get(win32_global_heap(), ## __VA_ARGS__)
	//void   win32_global_vector_set(DWORD width, char **vector, DWORD pos, char *val);
	#define win32_global_vector_set(...) win32_vector_set(win32_global_heap(), ## __VA_ARGS__)
	//void   win32_global_vector_push_back(DWORD width, char **vector, char *val);
	#define win32_global_vector_push_back(...) win32_vector_push_back(win32_global_heap(), ## __VA_ARGS__)
	//void   win32_global_vector_erase(DWORD width, char **vector, DWORD pos, char *val);
	#define win32_global_vector_erase(...) win32_vector_erase(win32_global_heap(), ## __VA_ARGS__)
	//void   win32_global_vector_insert(DWORD width, char **vector, DWORD pos, char *val);
	#define win32_global_vector_insert(...) win32_vector_insert(win32_global_heap(), ## __VA_ARGS__)
	/* Thread Heap */
	HANDLE win32_thread_heap(void);
	//void *win32_thread_malloc(size_t size);
	#define win32_thread_malloc(...) win32_heap_malloc(win32_thread_heap(), ## __VA_ARGS__)
	//void *win32_thread_realloc(void *block, size_t size);
	#define win32_thread_realloc(...) win32_heap_realloc(win32_thread_heap(), ## __VA_ARGS__)
	//size_t win32_thread_memlen(void *block);
	#define win32_thread_memlen(...) win32_heap_memlen(win32_thread_heap(), ## __VA_ARGS__)
	//void win32_thread_free(void *block);
	#define win32_thread_free(...) win32_heap_free(win32_thread_heap(), ## __VA_ARGS__)
	//void   win32_thread_vector_clear(DWORD width, char **vector);
	#define win32_thread_vector_clear(...) win32_vector_clear(win32_thread_heap(), ## __VA_ARGS__)
	//DWORD  win32_thread_vector_size(DWORD width, char **vector);
	#define win32_thread_vector_size(...) win32_vector_size(win32_thread_heap(), ## __VA_ARGS__)
	//void   win32_thread_vector_resize(DWORD width, char **vector, DWORD size);
	#define win32_thread_vector_resize(...) win32_vector_resize(win32_thread_heap(), ## __VA_ARGS__)
	//void   win32_thread_vector_reserve(DWORD width, char **vector, DWORD size);
	#define win32_thread_vector_reserve(...) win32_vector_reserve(win32_thread_heap(), ## __VA_ARGS__)
	//void   win32_thread_vector_get(DWORD width, char **vector, DWORD pos, char *val);
	#define win32_thread_vector_get(...) win32_vector_get(win32_thread_heap(), ## __VA_ARGS__)
	//void   win32_thread_vector_set(DWORD width, char **vector, DWORD pos, char *val);
	#define win32_thread_vector_set(...) win32_vector_set(win32_thread_heap(), ## __VA_ARGS__)
	//void   win32_thread_vector_push_back(DWORD width, char **vector, char *val);
	#define win32_thread_vector_push_back(...) win32_vector_push_back(win32_thread_heap(), ## __VA_ARGS__)
	//void   win32_thread_vector_erase(DWORD width, char **vector, DWORD pos, char *val);
	#define win32_thread_vector_erase(...) win32_vector_erase(win32_thread_heap(), ## __VA_ARGS__)
	//void   win32_thread_vector_insert(DWORD width, char **vector, DWORD pos, char *val);
	#define win32_thread_vector_insert(...) win32_vector_insert(win32_thread_heap(), ## __VA_ARGS__)
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus // ***** C++ only *****
#endif /* __cplusplus */

#endif /* _WIN32_H_ */
