﻿#undef NDEBUG
#include <assert.h>

#ifdef UNICODE
#define _UNICODE
#endif

#include <windows.h>
#include "win32.h"
#include "win32_print.h"
#include "win32_vector.h"
#include "tlsdecl.h"

//#include <stdint.h>
#include "MemoryModule.h"

#include <tchar.h>
#include <stdio.h>
#include <malloc.h>

#include <memory>
#include <cstdlib>
#include <iostream>
#include <string>
#include <vector>

#define DBG(format, ...) win32_printfA("[WMAIN(A)] " format "\n", ## __VA_ARGS__)
#define DBGW(format, ...) win32_printfW(L"[WMAIN(W)] " format L"\n", ## __VA_ARGS__)


template<class T>
class myallocator : public std::allocator<T> {
public:
#if 0x1
	typedef size_t   size_type;
	typedef T*       pointer;
	typedef const T* const_pointer;
#endif
    myallocator() { }
    //myallocator(const myallocator& x) { }
    
    template<class U>
    myallocator(const myallocator<U>& x) { }
    
    pointer allocate(size_type n, const_pointer hint = 0) { 
        //std::cout << "allocate " << n * sizeof(T) << "bytes" << std::endl;
        //return (pointer) std::malloc(n * sizeof(T));
    	UNREFERENCED_PARAMETER(hint);
		return (pointer)win32_global_malloc(sizeof(T) * n);
    }
    
    void deallocate(pointer ptr, size_type n) {
        //std::cout << "free pointer " << (void*) ptr << std::endl;
        //std::free(ptr);
    	UNREFERENCED_PARAMETER(n);
		win32_global_free(ptr);
    }
    
    template<class U>
    struct rebind { typedef myallocator<U> other; };
};
typedef std::basic_string< char, std::char_traits<char>, myallocator<char> > win32_global_string;

//win32_global_string g_glob_str = "GLOBAL STRING";

struct main_struct
{
public:
	const char *f_label;
	CRITICAL_SECTION f_csect;
	int f_a = 0;
	win32_global_string f_str = "[f_str]:漢字";
	explicit main_struct(const char* label): f_label(label)
	{
		DBG("main_struct(1): %s (f_str=%s)", f_label, f_str.c_str());
		f_a = 5678;
		DBG("main_struct(2): %s", f_label);
		InitializeCriticalSection(&f_csect);
		DBG("main_struct(3): %s", f_label);
	}
	virtual ~main_struct()
	{
		DBG("~main_struct(1): %s", f_label);
		DeleteCriticalSection(&f_csect);
		DBG("~main_struct(2): %s", f_label);
	}
};
////main_struct l_main_struct("l_main_struct");
main_struct *l_main_struct2 = NULL;

#ifdef __GNUC__
char l_main_struct_area_3[sizeof(main_struct)] __attribute__ ((__aligned__(16)));
#else
__declspec(align(16)) char l_main_struct_area_3[sizeof(main_struct)]; //FIXME
#endif
main_struct *l_main_struct3 = NULL;

#define TLS_CALLBACK_SECT ".CRT$XLB"
static void NTAPI main_tls_callback(PVOID hModule, DWORD dwReason, PVOID pReserved)
{
	UNREFERENCED_PARAMETER(hModule);
	UNREFERENCED_PARAMETER(pReserved);
	DBG("main_tls_callback(%s): dwReason=0x%08x (%s)", TLS_CALLBACK_SECT, dwReason, win32_tls_callback_reason_label(dwReason));
	//static main_struct s_main_struct("s_main_struc");
	//DBG("[A]");
	//s_main_struct.f_a = 2222;
	//DBG("[B]");
	switch(dwReason){
	case DLL_PROCESS_ATTACH:
		DBG("DLL_PROCESS_ATTACH(1)");
		{
			LPVOID v_addr = VirtualAlloc(
				(LPVOID)0x400000, //LPVOID lpAddress,        // 予約またはコミットしたい領域
				4096, //256*1024*1024, //SIZE_T dwSize,           // 領域のサイズ
				MEM_RESERVE, //DWORD flAllocationType,  // 割り当てのタイプ
				PAGE_READWRITE //DWORD flProtect          // アクセス保護のタイプ
			);
			DBG("v_addr=0x%08x", v_addr);
		}
		////l_main_struct.f_a = 1234;
		DBG("DLL_PROCESS_ATTACH(2)");
		{
			void *v_memory = win32_global_malloc(sizeof(main_struct));
			l_main_struct2 = new (v_memory) main_struct("l_main_struct2");
			l_main_struct2->~main_struct();
			win32_global_free(v_memory);
		}
		{
			DBG("l_main_struct_area_3=0x%08x", l_main_struct_area_3);
			l_main_struct3 = new (l_main_struct_area_3) main_struct("l_main_struct3");
			l_main_struct3->~main_struct();
		}
		DBG("DLL_PROCESS_ATTACH(3)");
		{
			DBG("DLL_PROCESS_ATTACH(4)");
			main_struct v_main_struct("v_main_struct");
			DBG("DLL_PROCESS_ATTACH(5)");
			v_main_struct.f_a = 1111;
			DBG("DLL_PROCESS_ATTACH(6)");
		}
#if 0x1
		{
			DBG("DLL_PROCESS_ATTACH(7)");
			//std::string v_str = "abc";
			//DBG("v_str=%s", v_str.c_str());
			std::basic_string< char, std::char_traits<char>, myallocator<char> > mys;
			mys = "xyz";
			//DBG("g_glob_str=%s", g_glob_str.c_str());
			DBG("mys=%s", mys.c_str());
			win32_global_string mys2 = "漢字";
			DBG("mys2=%s", mys2.c_str());
			std::vector< int, myallocator<int> > v;
			v.push_back(1111);
			v.push_back(2222);
			v.push_back(3333);
			DBG("v.size()=%u", v.size());
			std::vector< main_struct, myallocator<main_struct> > v2;
			main_struct v_added("v_added");
			v2.push_back(v_added);
			DBG("v2.size()=%u", v2.size());
			DBG("DLL_PROCESS_ATTACH(8)");
		}
#endif
		DBG("DLL_PROCESS_ATTACH(end)");
		break;
	case DLL_PROCESS_DETACH:
		break;
	case DLL_THREAD_ATTACH:
		break;
	case DLL_THREAD_DETACH:
		break;
	default:
		DBG("default: %u", dwReason);
		break;
	}
}
TLS_CALLBACK_DECL(TLS_CALLBACK_SECT, __main_tls_callback__, main_tls_callback);

static int RunFromMemory(void);

int wmain(int argc, wchar_t *argv[])
{
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);

	DBG("wmain() called");
	
	win32_debug_set(true);

#if 0x1
	HANDLE v_thread_heap = win32_thread_heap();
	DBG("wmain(): v_thread_heap=0x%08x", v_thread_heap);
	void *v_memory = win32_thread_malloc(1024);
	DBG("wmain(): v_memory=0x%08x", v_memory);
	void *v_memory2 = win32_thread_malloc(1024);
	DBG("wmain(): v_memory2=0x%08x", v_memory2);
	size_t v_size2 = win32_thread_memlen(v_memory2);
	DBG("wmain(): v_size2=%u", v_size2);
	void *v_memory3 = win32_thread_realloc(v_memory2, 1026);
	DBG("wmain(): v_memory3=0x%08x", v_memory3);
	size_t v_size3 = win32_thread_memlen(v_memory3);
	DBG("wmain(): v_size3=%u", v_size3);
	win32_thread_free(v_memory);
#endif
	static TLS_VARIABLE_DECL char *s_vector = NULL;
	size_t v_memlen1 = win32_thread_memlen(s_vector);
	DBG("wmain(): v_memlen1=%u", v_memlen1);
	DBG("wmain(): win32_thread_char_size(&s_vector)=%u", win32_thread_char_size(&s_vector));
	win32_thread_char_resize(&s_vector, 5);
	size_t v_memlen2 = win32_thread_memlen(s_vector);
	DBG("wmain(): v_memlen2=%u", v_memlen2);
	DBG("wmain(): win32_thread_char_size(&s_vector)=%u", win32_thread_char_size(&s_vector));
	static TLS_VARIABLE_DECL char *s_vector2 = NULL;
	win32_thread_char_push_back(&s_vector2, 'a');
	win32_thread_char_push_back(&s_vector2, 'b');
	win32_thread_char_push_back(&s_vector2, ' ');
	win32_thread_char_push_back(&s_vector2, 'c');
	win32_thread_char_push_back(&s_vector2, 0);
	win32_thread_char_insert(&s_vector2, 0, 'Z');
	DBG("wmain(): win32_thread_char_size(&s_vector2)=%u", win32_thread_char_size(&s_vector2));
	DBG("wmain(): s_vector2=%s", s_vector2);
	char erase1 = win32_thread_char_erase(&s_vector2, 0); UNREFERENCED_PARAMETER(erase1);
	char erase2 = win32_thread_char_erase(&s_vector2, 1); UNREFERENCED_PARAMETER(erase2);
	DBG("wmain(): s_vector2(after erase)=%s", s_vector2);
	DBG("wmain(): win32_thread_char_size(&s_vector2)=%u", win32_thread_char_size(&s_vector2));
	//win32_thread_char_resize(&s_vector2, 0);
	//win32_thread_char_clear(&s_vector2);
	DBG("ワイド文字列1＝%S", L"漢字");
	DBG("ワイド文字列2＝%s", L"漢字");
	DBGW(L"ワイド文字列3＝%s", L"漢字");
	DBG("zero char(1)='%c'", '\0');
	DBGW(L"zero char(2)='%c'", L'\0');
	//std::wstring wstring_printf(const wchar_t *format, ...);
	std::wstring v_zero_wstr = wstring_printf(L"zero char(3)='%c'", L'\0');
	DBGW(L"%s", v_zero_wstr.c_str());

	win32_thread_char_reserve(&s_vector2, 20);
	DBG("wmain(): win32_thread_char_size(&s_vector2)=%u", win32_thread_char_size(&s_vector2));
	win32_thread_char_reserve(&s_vector2, 15);
	DBG("wmain(): win32_thread_char_size(&s_vector2)=%u", win32_thread_char_size(&s_vector2));
	
	char c0 = win32_thread_char_get(&s_vector2, 0);
	DBG("wmain(): c0=%c", c0);
	win32_thread_char_set(&s_vector2, 4096, 'X');
	char c4096 = win32_thread_char_get(&s_vector2, 4096);
	DBG("wmain(): c4096=%d (%c)", c4096, c4096);
	DBG("wmain(): win32_thread_char_size(&s_vector2)=%u", win32_thread_char_size(&s_vector2));

	static TLS_VARIABLE_DECL wchar_t *s_wvector = NULL;
	win32_thread_wchar_push_back(&s_wvector, L'A');
	win32_thread_wchar_push_back(&s_wvector, L'B');
	win32_thread_wchar_push_back(&s_wvector, L'C');
	win32_thread_wchar_push_back(&s_wvector, 0);
	DBGW(L"wmain(): s_wvector=%s", s_wvector);
	wchar_t ec1 = win32_thread_wchar_erase(&s_wvector, 1);
	DBGW(L"wmain(): ec1=%c", ec1);
	DBGW(L"wmain(): s_wvector=%s", s_wvector);
	win32_thread_wchar_insert(&s_wvector, 1, L'漢');
	DBGW(L"wmain(): s_wvector=%s", s_wvector);

	RunFromMemory();

	DBG("wmain(end))");

	return 0;
}

//PeLdrSetExecutablePath(&peLdr, (wchar_t *)L"V:\\QtBuild\\#svn\\qt5.4.0\\#labo\\browser5.4.0\\release\\browser.exe");
//PeLdrSetExecutablePath(&peLdr, (wchar_t *)L"V:\\QtBuild\\#svn\\qt5.4.0\\#labo\\tls_01\\release\\main.exe");

//#define EXE_FILE TEXT("V:\\QtBuild\\#svn\\qt5.4.0\\#labo\\tls_01\\release\\main.exe")
#define EXE_FILE TEXT("V:\\QtBuild\\#svn\\qt5.4.0\\#labo\\browser5.4.0\\release\\browser.exe")

int RunFromMemory(void)
{
	FILE *fp;
	unsigned char *data=NULL;
	size_t size;
	HMEMORYMODULE handle;
	int result = -1;
	fp = _tfopen(EXE_FILE, _T("rb"));
	if (fp == NULL)
	{
	_tprintf(_T("Can't open executable \"%s\"."), EXE_FILE);
	goto exit;
	}
	fseek(fp, 0, SEEK_END);
	size = ftell(fp);
	data = (unsigned char *)malloc(size);
	fseek(fp, 0, SEEK_SET);
	fread(data, 1, size, fp);
	fclose(fp);
	handle = MemoryLoadLibrary(data);
	if (handle == NULL)
	{
	_tprintf(_T("Can't load library from memory.\n"));
	goto exit;
	}
	result = MemoryCallEntryPoint(handle);
	if (result < 0) {
	_tprintf(_T("Could not execute entry point: %d\n"), result);
	}
	MemoryFreeLibrary(handle);
	exit:
	if (data)
	free(data);
	return result;
}

