﻿#ifndef _SBOX_H_
#define _SBOX_H_

#include <windows.h>
#include "wine.h"
#include "sbox_print.h"
#include "tlsdecl.h"

#ifdef __cplusplus
extern "C" {
#endif
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus // ***** C++ only *****
class SBOX_THREAD
{
private:
	LPVOID f_orig_tlsp = NULL;
	LPVOID f_sbox_tlsp = NULL;
public:
	PWINE_TEB f_teb = NULL;
	bool f_is_root = false; 
	explicit SBOX_THREAD();
	virtual ~SBOX_THREAD();
};
extern TLS_VARIABLE_DECL SBOX_THREAD *g_sbox_thread;
class SBOX_PROCESS
{
private:
	std::vector<WineModuleInfo> f_root_module_list;
public:
	PWINE_TEB f_teb = NULL;
	SBOX_THREAD *f_root_thread = NULL;
	DWORD f_num_implicit_tls = 0;
	DWORD f_num_extended_tls = 0;
	explicit SBOX_PROCESS();
	virtual ~SBOX_PROCESS();
	void alloc_main_thread();
};
extern SBOX_PROCESS *g_sbox_process;
#endif /* __cplusplus */

#endif /* _SBOX_H_ */
