﻿#undef NDEBUG

#include "sbox.h"
#include <assert.h>
#include "strconv.h"

#define SBOX_DBG(format, ...) sync_fprintf(stderr, "[SBOX] " format "\n", ## __VA_ARGS__)

/*
    typedef struct _IMAGE_TLS_DIRECTORY32 {
      DWORD StartAddressOfRawData;
      DWORD EndAddressOfRawData;
      DWORD AddressOfIndex;
      DWORD AddressOfCallBacks;
      DWORD SizeOfZeroFill;
      DWORD Characteristics;
    } IMAGE_TLS_DIRECTORY32;
    typedef IMAGE_TLS_DIRECTORY32 *PIMAGE_TLS_DIRECTORY32;
*/

SBOX_PROCESS::SBOX_PROCESS()
{
	f_teb = WineNtCurrentTeb();
	f_root_module_list = WineEnumModuleInfos();
	SBOX_DBG("f_root_module_list.size()=%u", f_root_module_list.size());
	LONG v_max_tls_index = -1;
	for(ULONG i=0; i<f_root_module_list.size(); i++)
	{
		WineModuleInfo &v_wmi = f_root_module_list[i];
		SBOX_DBG("  f_root_module_list[%u]=%s", i, WIDE_TO_ANSI(f_root_module_list[i].ToString()));
		if(v_wmi.TlsIndex > v_max_tls_index)
		{
			v_max_tls_index = v_wmi.TlsIndex;
		}
	}
	f_num_implicit_tls = v_max_tls_index + 1;
	//f_num_extended_tls = 64; // FIXME
	f_num_extended_tls = 16; // FIXME
	SBOX_DBG("SBOX_PROCESS created: 0x%08x (IMPLICIT_TLS=%u)", f_teb, f_num_implicit_tls);
}
SBOX_PROCESS::~SBOX_PROCESS()
{
	if(f_root_thread)
	{
		delete f_root_thread;
		f_root_thread = NULL;
	}
	SBOX_DBG("SBOX_PROCESS deleted: 0x%08x (IMPLICIT_TLS=%u)", f_teb, f_num_implicit_tls);
}
void SBOX_PROCESS::alloc_main_thread()
{
	assert(f_teb == WineNtCurrentTeb());
	g_sbox_thread = new SBOX_THREAD();
	f_root_thread = g_sbox_thread;
}
SBOX_PROCESS *g_sbox_process = new SBOX_PROCESS();

SBOX_THREAD::SBOX_THREAD()
{
	assert(g_sbox_process);
	assert(g_sbox_process->f_teb);
	f_teb = WineNtCurrentTeb();
	assert(f_teb);
	if(f_teb == g_sbox_process->f_teb)
	{
		f_is_root = true;
	}
	else
	{
		f_is_root = false;
	}
	//assert(f_teb->ThreadLocalStoragePointer); // f_teb->ThreadLocalStoragePointer might be NULL;
	f_orig_tlsp = f_teb->ThreadLocalStoragePointer;
	f_sbox_tlsp = NULL;
	assert(g_sbox_process->f_num_extended_tls >= g_sbox_process->f_num_implicit_tls);
	if(g_sbox_process->f_num_extended_tls)
	{
		size_t v_byte_size = sizeof(LPVOID) * g_sbox_process->f_num_extended_tls;
		//SBOX_DBG("v_byte_size=%u", v_byte_size);
		f_sbox_tlsp = (PVOID)_aligned_malloc(v_byte_size, 16);
		memset(f_sbox_tlsp, 0, v_byte_size);
		if(g_sbox_process->f_num_implicit_tls)
		{
			assert(f_orig_tlsp);
			for(DWORD i=0; i<g_sbox_process->f_num_implicit_tls; i++)
			{
				((DWORD *)f_sbox_tlsp)[i] = ((DWORD *)f_orig_tlsp)[i];
			}
		}
		f_teb->ThreadLocalStoragePointer = f_sbox_tlsp;
	}
	//SBOX_DBG("SBOX_THREAD created: 0x%08x ORIG_TLSP=0x%08x SBOX_TLSP=0x%08x%s", f_teb, f_orig_tlsp, f_sbox_tlsp, f_is_root?" (ROOT)":"");
	SBOX_DBG("SBOX_THREAD created: 0x%08x%s", f_teb, f_is_root?" (ROOT)":"");
}
SBOX_THREAD::~SBOX_THREAD()
{
	//SBOX_DBG("SBOX_THREAD deleted: 0x%08x ORIG_TLSP=0x%08x SBOX_TLSP=0x%08x%s", f_teb, f_orig_tlsp, f_sbox_tlsp, f_is_root?" (ROOT)":"");
	SBOX_DBG("SBOX_THREAD deleted: 0x%08x%s", f_teb, f_is_root?" (ROOT)":"");
	assert(f_teb);
	f_teb->ThreadLocalStoragePointer = f_orig_tlsp;
	if(f_sbox_tlsp)
	{
		_aligned_free(f_sbox_tlsp);
	}
}
TLS_VARIABLE_DECL SBOX_THREAD *g_sbox_thread = NULL;

#ifndef DLL_PROCESS_VERIFIER
#define DLL_PROCESS_VERIFIER 4
#endif

static const char *sbox_callback_reason_label(DWORD dwReason)
{
	switch(dwReason){
	case DLL_PROCESS_ATTACH:
		return "DLL_PROCESS_ATTACH";
	case DLL_PROCESS_DETACH:
		return "DLL_PROCESS_DETACH";
	case DLL_THREAD_ATTACH:
		return "DLL_THREAD_ATTACH";
	case DLL_THREAD_DETACH:
		return "DLL_THREAD_DETACH";
	case DLL_PROCESS_VERIFIER:
		return "DLL_PROCESS_VERIFIER";
	}
	return "UNKNOWN";
}

static void NTAPI sbox_tls_callback(PVOID hModule, DWORD dwReason, PVOID lpReserved)
{
	UNREFERENCED_PARAMETER(hModule);
	UNREFERENCED_PARAMETER(lpReserved);
	SBOX_DBG("sbox_tls_callback(): dwReason=0x%08x (%s)", dwReason, sbox_callback_reason_label(dwReason));
	switch(dwReason){
	case DLL_PROCESS_ATTACH:
		break;
	case DLL_PROCESS_DETACH:
		if(g_sbox_process)
		{
			delete g_sbox_process;
			g_sbox_process = NULL;
		}
		break;
	case DLL_THREAD_ATTACH:
		assert(g_sbox_thread == NULL);
		g_sbox_thread = new SBOX_THREAD();
		break;
	case DLL_THREAD_DETACH:
		if(g_sbox_thread)
		{
			delete g_sbox_thread;
			g_sbox_thread = NULL;
		}
		break;
	default:
		break;
	}
}
TLS_CALLBACK_DECL(".CRT$XLB", __sbox_tls_callback__, sbox_tls_callback);
