﻿#include <windows.h>
#include <iostream>
#include <boost/locale.hpp>
#include <boost/algorithm/string/case_conv.hpp>

//using namespace std;

std::wstring s2ws(const std::string& s)
{
	int len;
	//int slength = (int)s.length() + 1;
	int slength = (int)s.length();
	len = MultiByteToWideChar(CP_ACP, 0, s.c_str(), slength, 0, 0); 
	std::wstring r(len, L'\0');
	MultiByteToWideChar(CP_ACP, 0, s.c_str(), slength, &r[0], len);
	return r;
}

std::string ws2s(const std::wstring& s)
{
	int len;
	//int slength = (int)s.length() + 1;
	int slength = (int)s.length();
	len = WideCharToMultiByte(CP_ACP, 0, s.c_str(), slength, 0, 0, 0, 0); 
	std::string r(len, '\0');
	WideCharToMultiByte(CP_ACP, 0, s.c_str(), slength, &r[0], len, 0, 0); 
	return r;
}

int wmain(int argc, wchar_t *argv[])
{
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);

//	std::cout << boost::locale::conv::from_utf("grüßen vs ", "ISO8859-15");
//	std::cout << boost::locale::conv::from_utf(boost::locale::to_upper("grüßen"), "ISO8859-15") << std::endl;
//	std::cout << boost::locale::conv::from_utf(boost::locale::fold_case("grüßen"), "ISO8859-15") << std::endl;
//	std::cout << boost::locale::conv::from_utf(boost::locale::normalize("grüßen", boost::locale::norm_nfd), "ISO8859-15") << std::endl;
	std::wstring v_wstr = L"テスト";
	std::cout << "(1)" << boost::locale::conv::from_utf(v_wstr, "shift_jis") << std::endl;
	std::cout << "(2)" << ws2s(v_wstr) << std::endl;

	return 0;
}
